/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

package com.urbancode.air.plugin.f5

import iControl.Interfaces
import iControl.LocalLBDataGroupFile
import iControl.LocalLBDataGroupType

public class F5DataGroupFile{

    Interfaces interfaces

    // Constructor for F5DataGroupFile
    public F5DataGroupFile(Interfaces interfaces) {
        this.interfaces = interfaces
    }

    // Retrieve the full data group file list
    public String[] getDataGroupFileList() {
        return interfaces.getLocalLBDataGroupFile().get_list()
    }

    // Confirm whether data group file object exists in set partition
    public Boolean doesDataGroupFileExist(String file_name){
        println getDataGroupFileList()
        if (getDataGroupFileList().contains(file_name)) {
            return true
        }
        return false
    }
}
