/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.f5.F5Node

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()
final def checkAvailability = Boolean.valueOf(props['checkAvailability'])

try {
    def stepStatus
    F5Node node = new F5Node(props)

    println "Checking Node Enabled Status..."
    if (node.getNodeEnabledStatus() != node.NEGATIVE) {
        println "Failing step at Node Disabled"
        stepStatus = "Failure"
    }

    if(checkAvailability) {
        println "Checking Node Monitor Status..."
        if (node.getNodeMonitorStatus() != node.NEGATIVE) {
            println "Failing step at Monitor Disabled"
            stepStatus = "Failure"
        }

        println "Check Node Availability..."
        if (node.getNodeAvailability() != node.NEGATIVE) {
            println "Failing step at Node Non-Availability"
            stepStatus = "Failure"
        }
    }

    apTool.setOutputProperty("Status", stepStatus ?: "Success")
    apTool.setOutputProperties()
}
catch (Exception e) {
    e.printStackTrace()
    System.exit(1)
}
