/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.f5.F5iRule

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()
def exitVal = 1
try {
    F5iRule iRule = new F5iRule(props)
    def iRuleName = props['iRuleName']
    iRuleName = iRule.appendFolderNames(iRuleName)[0]
    def definition = props['definition']

    // Open the definition file, confirm its existance, and put text into a string
    def filePathString = definition.replace('\\', '/')
    File definitionFile = new File(filePathString)
    // Check if the given path exists
    if (definitionFile.isFile()) {
        println "${definitionFile} found!"
        definition = definitionFile.getText('UTF-8')
    }
    // Else, assume a full definition was given
    else {
        if (filePathString.length() > 100 ) {
            println "Input is not a file... using as defintion."
        }
        else {
            println "${definitionFile} is not a file... using as defintion."
        }
    }

    // Create the iRule
    exitVal = iRule.createiRule(iRuleName, definition)
}
catch (Exception e) {
    e.printStackTrace()
    System.exit(1)
}

// Crash if failStrategy == 'FAIL_FAST'
def failStrategy = props['failStrategy']
println "If the iRule already exists, the selected fail strategy is: ${failStrategy}"
if (exitVal == 1 && failStrategy == 'FAIL') {
    System.exit(1)
}
