/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.f5.F5Class

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()

def failStrategy = props['failStrategy']
def exitVal = 1
try {
    F5Class dataGroup = new F5Class(props)
    def name = props['name']
    name = dataGroup.appendFolderNames(name)[0]
    String[] members = dataGroup.text2StringArray(props['members'])
    println "If the String Data Group already exists, the selected strategy is: ${failStrategy}"

    // Create the String Data Group
    // 0 == Data Group successfully created
    // 1 == Data Group already exists
    // Crash gracefully otherwise
    exitVal = dataGroup.createStringClass(name, members)

    if (exitVal == 1 && failStrategy == 'OVERWRITE') {
        exitVal = dataGroup.modifyStringClass(name, members)
    }
}
catch (Exception e) {
    e.printStackTrace()
    System.exit(1)
}

// Crash if failStrategy == 'FAIL'
if (exitVal == 1 && failStrategy == 'FAIL') {
    System.exit(1)
}
