/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.f5.F5Class
import com.urbancode.air.plugin.f5.F5DataGroupFile

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()

def exitVal = 1
try {
    F5Class dataGroup = new F5Class(props)
    def name = props['name']
    name = dataGroup.appendFolderNames(name)[0]
    String file_format = props['file_format']
    String file_mode = props['file_mode']

    // Modify the External Data Group
    exitVal = dataGroup.modifyExternalClass(name, file_format, file_mode)
}
catch (Exception e) {
    e.printStackTrace()
    System.exit(1)
}
