/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

helper = new CommandHelper()

final def isWindows = apTool.isWindows

final def REPO_PATH_SEPARATOR = isWindows ? "\\" : "/"

String installPath = props['installPath'].trim()
String profile = props['profile'].trim()
String solutionName = props['solutionName'].trim()
String manifestName = props['manifestName'].trim()
String targetEnvName = props['targetEnvName'].trim()

while (installPath.endsWith(REPO_PATH_SEPARATOR)) {
    installPath = installPath.substring(0, installPath.length()-1)
}

String configMgrFile = isWindows ? "configmgr_cl.exe" : "configmgr_cl"

String configMgr = installPath + REPO_PATH_SEPARATOR + "configure" + REPO_PATH_SEPARATOR + configMgrFile

println("Checking for file '$configMgr'")

if (!new File(configMgr).isFile()) {
    throw new Exception("Could not find configmgr_cl executable")
}

def cmdArgs = [configMgr]

cmdArgs << "applySolutionSecurityManifest"
cmdArgs << "-profile"
cmdArgs << profile

if (targetEnvName) {
    cmdArgs << "-targetEnvName"
    cmdArgs << targetEnvName
}

cmdArgs << "-solutionName"
cmdArgs << solutionName
cmdArgs << "-manifestName"
cmdArgs << manifestName

//force through all prompts with default values
cmdArgs << "-force"
cmdArgs << "-silent"

helper.runCommand("Applying security manifest", cmdArgs)

System.exit(0)