/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.iterator;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.iterator.BoolArrayAccessor;
import com.urbancode.commons.util.iterator.ByteArrayAccessor;
import com.urbancode.commons.util.iterator.CharArrayAccessor;
import com.urbancode.commons.util.iterator.DoubleArrayAccessor;
import com.urbancode.commons.util.iterator.FloatArrayAccessor;
import com.urbancode.commons.util.iterator.IntArrayAccessor;
import com.urbancode.commons.util.iterator.LongArrayAccessor;
import com.urbancode.commons.util.iterator.ObjectArrayAccessor;
import com.urbancode.commons.util.iterator.ShortArrayAccessor;

abstract class ArrayAccessor<T> {
    ArrayAccessor() {
    }

    public static <T> ArrayAccessor<T> get(Object array) {
        Check.nonNull(array, "array");
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("not an array");
        }
        Class<?> type = array.getClass().getComponentType();
        if (type == Byte.TYPE) {
            return new ByteArrayAccessor((byte[])array);
        }
        if (type == Boolean.TYPE) {
            return new BoolArrayAccessor((boolean[])array);
        }
        if (type == Short.TYPE) {
            return new ShortArrayAccessor((short[])array);
        }
        if (type == Character.TYPE) {
            return new CharArrayAccessor((char[])array);
        }
        if (type == Integer.TYPE) {
            return new IntArrayAccessor((int[])array);
        }
        if (type == Long.TYPE) {
            return new LongArrayAccessor((long[])array);
        }
        if (type == Float.TYPE) {
            return new FloatArrayAccessor((float[])array);
        }
        if (type == Double.TYPE) {
            return new DoubleArrayAccessor((double[])array);
        }
        return new ObjectArrayAccessor((Object[])array);
    }

    public abstract T get(int var1);

    public abstract void set(int var1, T var2);

    public abstract int length();
}

