/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ImportVersion {
    private static final Logger log = Logger.getLogger(ImportVersion.class);
    private Properties inputProperties;
    private Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            String versionId;
            VersionClient versionClient;
            Properties props = new Properties();
            props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
            PropertyConfigurator.configure((Properties)props);
            Properties agentProps = new Properties();
            agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
            String charsetName = agentProps.getProperty("system.default.encoding");
            String componentName = this.inputProperties.getProperty("componentName");
            String versionName = this.inputProperties.getProperty("name");
            String versionDescription = this.inputProperties.getProperty("description");
            String extensionString = this.inputProperties.getProperty("extensions");
            boolean isAutomatic = Boolean.valueOf(this.inputProperties.getProperty("isAutoIntegration"));
            if (!isAutomatic) {
                String[] extensions = new String[]{};
                if (extensionString != null) {
                    extensions = extensionString.split(",");
                    for (int i = 0; i < extensions.length; ++i) {
                        extensions[i] = extensions[i].trim();
                    }
                }
                Charset charset = null;
                if (charsetName != null) {
                    charset = Charset.forName(charsetName);
                }
                if (versionDescription == null) {
                    versionDescription = "";
                }
                String namePattern = this.inputProperties.getProperty("namePattern");
                String nextNumberString = this.inputProperties.getProperty("nextNumber");
                String basePath = this.inputProperties.getProperty("basePath");
                String[] includes = new String[]{"**/*"};
                String[] excludes = new String[]{};
                boolean useNamePattern = Boolean.valueOf(this.inputProperties.getProperty("useNamePattern"));
                boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
                File baseDir = new File(basePath);
                boolean saveExecutePermissions = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
                String username = "PasswordIsAuthToken";
                String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
                String webUrl = System.getenv("AH_WEB_URL");
                URI url = new URI(webUrl);
                versionClient = new VersionClient(url, username, password);
                ComponentClient componentClient = new ComponentClient(url, username, password);
                if (useNamePattern) {
                    Integer nextNumber;
                    try {
                        nextNumber = Integer.valueOf(nextNumberString);
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("The configured next version number '" + nextNumberString + "' is not a valid integer.");
                    }
                    versionName = namePattern.replace("${version}", String.valueOf(nextNumber));
                    Integer n = nextNumber;
                    Integer n2 = nextNumber = Integer.valueOf(nextNumber + 1);
                    componentClient.updateSourceConfigProperty(componentName, "nextNumber", nextNumber.toString(), "", Boolean.valueOf(false));
                }
                System.out.println(String.format("Creating new version: %s", versionName));
                versionId = versionClient.createVersion(componentName, versionName, versionDescription, true).toString();
                this.outputProperties.setProperty("VersionID", versionId);
                if (isUseVFS) {
                    System.out.println("Uploading artifact files.");
                    versionClient.addVersionFiles(componentName, versionId, baseDir, "", includes, excludes, saveExecutePermissions, true, charset, extensions);
                } else {
                    System.out.println("Skipping Artifact Upload: Component is configured not to use codestation.");
                }
            } else {
                throw new RuntimeException("Automatic Integration is not supported for this Source Configuration.");
            }
            versionClient.markImportFinished(componentName, versionId);
        }
        catch (Exception e) {
            System.err.println(String.format("Error Creating New Version: %s", e.getMessage()));
            return 1;
        }
        return 0;
    }
}

