/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class ImportVersion {
    private Properties inputProperties;
    private Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            String excludesStr;
            Properties props = new Properties();
            props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
            PropertyConfigurator.configure((Properties)props);
            Properties agentProps = new Properties();
            agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
            String charsetName = agentProps.getProperty("system.default.encoding");
            String componentName = this.inputProperties.getProperty("componentName");
            String extensionString = this.inputProperties.getProperty("extensions");
            String[] extensions = new String[]{};
            if (extensionString != null) {
                extensions = extensionString.split(",");
                for (int i = 0; i < extensions.length; ++i) {
                    extensions[i] = extensions[i].trim();
                }
            }
            Charset charset = null;
            if (charsetName != null) {
                charset = Charset.forName(charsetName);
            }
            String basePath = this.inputProperties.getProperty("basePath");
            boolean preserveExecutePermissions = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
            boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
            File baseDir = new File(basePath);
            String username = "PasswordIsAuthToken";
            String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
            String webUrl = System.getenv("AH_WEB_URL");
            URI url = new URI(webUrl);
            String regexp = "[,\\n]";
            String includesStr = this.inputProperties.getProperty("includes");
            if (includesStr == null || includesStr.equals("")) {
                includesStr = "**/*";
            }
            if ((excludesStr = this.inputProperties.getProperty("excludes")) == null) {
                excludesStr = "";
            }
            String[] includes = includesStr.split(regexp);
            String[] excludes = excludesStr.split(regexp);
            ComponentClient componentClient = new ComponentClient(url, username, password);
            VersionClient versionClient = new VersionClient(url, username, password);
            List versionNames = componentClient.getComponentVersions(componentName, Boolean.valueOf(true));
            ArrayList<File> newVersions = new ArrayList<File>();
            if (baseDir.exists() && baseDir.isDirectory()) {
                for (File versionDir : baseDir.listFiles()) {
                    if (!versionDir.isDirectory() || versionNames.contains(versionDir.getName())) continue;
                    newVersions.add(versionDir);
                }
            } else {
                throw new IOException("The provided base is not a directory: " + baseDir.getAbsolutePath());
            }
            if (!newVersions.isEmpty()) {
                System.out.println("Creating new Versions of Component " + componentName + ":");
                for (File version : newVersions) {
                    String versionId = "";
                    if (isUseVFS) {
                        System.out.println(String.format("Creating new version %s and Uploading artifact files.", version));
                        versionId = versionClient.createAndAddVersionFiles(componentName, version.getName(), "", version, "", includes, excludes, preserveExecutePermissions, true, charset, extensions).toString();
                    } else {
                        System.out.println(String.format("Creating new version: %s", version.getName()));
                        versionId = versionClient.createVersion(componentName, version.getName(), "").toString();
                        System.out.println("Skipping Artifact Upload: Component " + componentName + " is configured not to use codestation.");
                    }
                    this.outputProperties.setProperty("VersionID", versionId);
                }
            } else {
                System.out.println("No new Versions of Component " + componentName + " added.");
            }
        }
        catch (Exception e) {
            System.err.println(String.format("Error Creating New Version: %s", e.getMessage()));
            e.printStackTrace();
            return 1;
        }
        return 0;
    }
}

