/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import com.urbancode.commons.httpcomponentsutil.ConnectionManagerCleaner;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SharedConnectionCleaner
extends Thread {
    private static final Logger log = Logger.getLogger(SharedConnectionCleaner.class);
    private static SharedConnectionCleaner sharedInstance;
    private final ConcurrentLinkedQueue<ConnectionManagerCleaner<?>> cleaners = new ConcurrentLinkedQueue();

    static synchronized void track(ConnectionManagerCleaner<?> cleaner) {
        if (sharedInstance == null) {
            sharedInstance = new SharedConnectionCleaner();
            sharedInstance.start();
        }
        sharedInstance.track0(cleaner);
    }

    SharedConnectionCleaner() {
        this.setName("Idle connection cleaner [shared]");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            block4: while (true) {
                Thread.sleep(10000L);
                Iterator<ConnectionManagerCleaner<?>> itr = this.cleaners.iterator();
                while (true) {
                    if (!itr.hasNext()) continue block4;
                    ConnectionManagerCleaner<?> cleaner = itr.next();
                    try {
                        boolean needsFutureCleaning = cleaner.cleanConnections();
                        if (needsFutureCleaning) continue;
                        itr.remove();
                    }
                    catch (Exception e) {
                        log.error("Error in cleaner thread", e);
                        itr.remove();
                    }
                }
                break;
            }
        }
        catch (InterruptedException e) {
            if (log.isDebugEnabled()) {
                log.debug("Terminated by interrupt", e);
            }
            return;
        }
    }

    private void track0(ConnectionManagerCleaner<?> cleaner) {
        this.cleaners.add(cleaner);
    }
}

