final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def dirOffset = props['dir']?:'.'
def tarball = props['tarball'];
def compression = props['compression'];
def overwrite = Boolean.valueOf(props['overwrite']);

try {

    def ant = new AntBuilder()
    if (overwrite) {
        ant.untar(
                dest:dirOffset,
                failOnEmptyArchive: 'true',
                compression: compression,
                overwrite: 'true',
                src: tarball)
    }
    else {
        ant.untar(
                dest:dirOffset,
                failOnEmptyArchive: 'true',
                compression: compression,
                overwrite: 'false',
                src: tarball)
    }
}
catch (Exception e) {
    e.printStackTrace()
    println "Error extracting tarball!"
    System.exit(1)
}
finally {
}

System.exit(0)

