final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

final def dir = props['dir']

def errors = [];
try {
    dir.eachLine {
        File file = new File(it).canonicalFile;
        if (file.isDirectory()) {
            println "Directory '$file.absolutePath' already exists!"
        }
        else if (file.isFile()) {
            errors << "There is a file at '$file.absolutePath'";
        }
        else if (file.mkdirs()) {
            println "Created new directory '$file.absolutePath'"
        }
        else {
            errors << "Could not create directory '$file.absolutePath'";
        }
    }
}
catch (Exception e) {
    println "Error creating directory '$dir': ${e.message}"
    System.exit(1)
}

if (errors.size() > 0) {
    errors.each { it ->
        println it;
    }
    System.exit(1);
}

System.exit(0)

