/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool

final airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

final def baseDir = props['baseDir']
final def zipName = props['zipName']
final def includes = props['includes']
final def excludes = props['excludes']
final def update = props['update']
final def followSymlinks = props['followSymlinks']
final def caseSensitive = props['caseSensitive']

println "Working Directory: ${new File('.').canonicalFile}"
println "Base Directory: $baseDir"
println "Zip file name: $zipName"
println "Include: $includes"
println "Exclude: $excludes"
println "Update : $update"
println "Follow Symlinks: $followSymlinks"
println "Case Sensitive: $caseSensitive"
println "================================="

def errors = false

try {
    if (new File(baseDir).exists()) {
        def ant = new AntBuilder()
        ant.zip(destfile: zipName, update: update) {
            fileset(dir:baseDir, casesensitive: caseSensitive, followsymlinks: followSymlinks, defaultexcludes: 'false') {
                includes.split('[\r\n]').each {
                    if (it && it.trim().length() > 0) {
                        include(name: it.trim())
                    }
                }
                excludes?.split('[\r\n]')?.each {
                    if (it && it.trim().length() > 0) {
                        exclude(name: it.trim())
                    }
                }
            }

        }
    }
    else {
        throw new Exception("$baseDir does not exist!")
    }
}
catch (Exception e) {
    println "Error creating zip archive: ${e.message}"
    errors = true
}

if (errors) System.exit 1

System.exit(0)

