/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def dirOffset = props['dir']?:'.'
def zipFile = props['zip'];
def overwrite = Boolean.valueOf(props['overwrite']);
def includes = props['includes'];
def excludes = props['excludes'];

try {

    def ant = new AntBuilder()
    if (overwrite) {
        ant.unzip(
                dest:dirOffset,
                failOnEmptyArchive: 'true',
                overwrite: 'true') {
            fileset(dir:'.', includes:zipFile, casesensitive:'false')
            patternset(includes: includes, excludes: excludes)
        }
    }
    else {
        ant.unzip(
                dest:dirOffset,
                failOnEmptyArchive: 'true',
                overwrite: 'false',) {
            fileset(dir:'.', includes:zipFile, casesensitive:'false')
            patternset(includes: includes, excludes: excludes)
        }
    }
}
catch (Exception e) {
    e.printStackTrace()
    println "Error extracting zip!"
    System.exit(1)
}
finally {
}

System.exit(0)

