/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def dirOffset = props['dir']
final def includes = props['includes']
final def excludes = props['excludes']
def updateProps = props['updateProps']
def deleteProps = props['deleteProps']
def additionalProps = props['additionalProps']
def String additionalPropsPrefix = props['additionalPropsPrefix']

if (dirOffset) {
    workDir = new File(workDir, dirOffset).canonicalFile
}

println "Working directory: ${workDir.canonicalPath}"
println "File Includes: ${includes}"
println "File Excludes: ${excludes}"

def ant = new AntBuilder()
def scanner = ant.fileScanner {
    fileset(dir:workDir.canonicalPath) {
        includes.split('\n').each {
            if (it && it.trim().length() > 0) {
                include(name:it.trim())
            }
        }

        if(excludes) {
            excludes.split('\n').each {
                if (it && it.trim().length() > 0) {
                    exclude(name:it.trim())
                }
            }
        }
    }
}
for(propFile in scanner) {
    println "Property File: ${propFile.canonicalPath}"
    println "Update Properties:\n${updateProps?:''}\n"
    println "Additional Update Properties:\n${additionalProps?:''}\n"
    println "Additional Update Properties Prefix:${additionalPropsPrefix?:''}\n"
    println "Delete Properties:\n${deleteProps?:''}\n"

try {
    if (updateProps?.trim().size() > 0 || deleteProps?.trim().size() > 0 || additionalProps?.trim().size() > 0) {
        ant.propertyfile(file: propFile.canonicalPath) {
            if(additionalProps) {
                if (additionalPropsPrefix) {
                    println "Looking for properties starting with $additionalPropsPrefix"
                }
                //this is jeffs magic regex to split on ,'s preceded by even # of \ including 0
                additionalProps.split("(?<=(^|[^\\\\])(\\\\{2}){0,8}),").each { prop ->
                    //split out the name
                    def parts = prop.split("(?<=(^|[^\\\\])(\\\\{2}){0,8})=",2);
                    def propName = parts[0];
                    def propValue = parts.size() == 2 ? parts[1] : "";
                    //replace \, with just , and then \\ with \
                    propName = propName.replace("\\=", "=").replace("\\,", ",").replace("\\\\", "\\")
                    propValue = propValue.replace("\\=", "=").replace("\\,", ",").replace("\\\\", "\\")

                    if (additionalPropsPrefix && propName.startsWith(additionalPropsPrefix)) {
                        propName = propName.substring(additionalPropsPrefix.length())
                        entry(key:propName,
                                value: propValue,
                                operation: '=')
                        println 'additional property: ' + propName + '=' + propValue
                    }
                    else if (!additionalPropsPrefix) {
                        entry(key:propName,
                                value: propValue,
                                operation: '=')
                        println 'additional property: ' + propName + '=' + propValue
                    }
                }
            }
            updateProps?.trim().split('\n').each {
                def index = it?.trim().indexOf('=')
                if (it && index != -1) {
                    entry(key:it.trim().substring(0, index),
                          value: it.trim().substring(index + 1),
                          operation: '=')
                }
            }
            deleteProps?.trim().split('\n').each {
                if (it.trim().size() > 0) {
                    entry(key:it.trim(), operation: 'del')
                }
            }
        }
    }
}
    catch (Exception e) {
        println "Error updating property file ${propFile.canonicalPath}: ${e.message}"
        System.exit(1)
        }
}
System.exit(0)

