/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def dirOffset = props['dir']?:'.'
def tarball = props['tarball'];
def compression = props['compression'];
def overwrite = Boolean.valueOf(props['overwrite']);

def overwrite_str = 'false'
if (overwrite){
    overwrite_str = 'true'
}

try {

    def ant = new AntBuilder()
    def fileDir ="."
    def tarballfile =new File(tarball)
    if(tarballfile.parent) {
        fileDir= tarballfile.parentFile.canonicalPath
    }
    
    println "File directory is: ${fileDir}"
    
    ant.untar(
            dest:dirOffset,
            failOnEmptyArchive: 'true',
            compression: compression,
            overwrite: overwrite_str) {
                fileset(dir:fileDir, includes:tarballfile.name)
            }
}
catch (Exception e) {
    e.printStackTrace()
    println "Error extracting tarball!"
    System.exit(1)
}
finally {
}

System.exit(0)

