/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool

final airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

final def baseDir = props['baseDir']
final def includes = props['includes']
final def excludes = props['excludes'] ?: ""
final def followSymlinks = Boolean.valueOf(props['followSymlinks'])
final def caseSensitive = Boolean.valueOf(props['caseSensitive'])

println "Working Directory: ${new File('.').canonicalFile}"
println "Base Directory: $baseDir"
println "Include: $includes"
println "Exclude: $excludes"
println "Follow Symlinks: $followSymlinks"
println "Case Sensitive: $caseSensitive"
println "================================="

def errors = false

try {
    if (new File(baseDir).exists()) {
        def ant = new AntBuilder()
        ant.delete(verbose: 'true', includeemptydirs: 'true') {
            fileset(dir:baseDir, casesensitive: caseSensitive, followsymlinks: followSymlinks, defaultexcludes: 'false') {
                includes.split('[\r\n]').each {
                    if (it && it.trim().length() > 0) {
                        include(name: it.trim())
                    }
                }
                excludes.split('[\r\n]').each {
                    if (it && it.trim().length() > 0) {
                        exclude(name: it.trim())
                    }
                }
            }

        }
    }
    else {
        println "$baseDir does not exist, nothing to do!"
    }
}
catch (Exception e) {
    println "Error deleting directories: ${e.message}"
    errors = true
}

if (errors) System.exit 1

System.exit(0)
