/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool

final AirPluginTool airTool = new AirPluginTool(args[0], args[1])
final Properties props = airTool.getStepProperties()

final def workDir = new File('.').canonicalFile

final def includes = props['includes'];
final def excludes = props['excludes'];
def lineEnding = null;

if (props['lineEnding'] == 'os') {
   println "using os line endings"
   lineEnding = System.getProperty("line.separator");
}
else if (props['lineEnding'] == 'unix') {
   println "using unix line endings"
   lineEnding = "\n";
}
else {
   println "using windows line endings"
   lineEnding = "\r\n";
}

def ant = new AntBuilder();

def flip = { file ->
    File tempFile = File.createTempFile("temp", "file");
    file.eachLine { line ->
       tempFile.append(line);
       tempFile.append(lineEnding);
    }
    ant.copy(file:tempFile.getAbsolutePath(), tofile:file.getAbsolutePath(), overwrite:true);
    tempFile.delete();
}


def scanner = ant.fileScanner {
    fileset(dir:".") {
       for (def includeRule in includes.split("\n")) {
           include(name:includeRule);
       }
       for (def excludeRule in excludes.split("\n")) {
           exclude(name:excludeRule);
       }
    }
}

for (f in scanner) {
   System.out.println("Flipping line ending for file " + f.name);
   flip(f);
}
