/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool

final AirPluginTool airTool = new AirPluginTool(args[0], args[1])
final Properties props = airTool.getStepProperties()
final def workDir = new File('.').canonicalFile

def dirOffset = props['dir']?:'.'
def tarball = props['tarball'];
def compression = props['compression'];
def overwrite = Boolean.valueOf(props['overwrite']);

def overwrite_str = 'false'
if (overwrite){
    overwrite_str = 'true'
}

try {

    def ant = new AntBuilder()
    def fileDir ="."
    def tarballfile =new File(tarball)
    if(tarballfile.parent) {
        fileDir= tarballfile.parentFile.canonicalPath
    }

    if(!new File(tarballfile.canonicalPath).isFile()) {
        println "[Error] File '${tarballfile.canonicalPath}' not found or is a directory."
        System.exit(1)
    }

    println "File directory is: ${fileDir}"

    ant.untar(
            dest:dirOffset,
            failOnEmptyArchive: 'true',
            compression: compression,
            overwrite: overwrite_str) {
                fileset(dir:fileDir, includes:tarballfile.name)
            }
}
catch (Exception e) {
    e.printStackTrace()
    println "Error extracting tarball!"
    System.exit(1)
}
finally {
}

System.exit(0)
