/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool
import java.util.Properties

def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
final def props = apTool.getStepProperties()

def dirOffset = props['dir']
def fileName = props['file']

if (dirOffset) {
    workDir = new File(workDir, dirOffset).canonicalFile
}

def propFile = new File(workDir, fileName)

println "Working directory: ${workDir.canonicalPath}"
println "Property File: ${propFile.canonicalPath}"

try {
    def loadedProps = new Properties()
    loadedProps.load(new File(propFile.canonicalPath).newInputStream())
    loadedProps.each{ cur ->
        apTool.setOutputProperty(cur.key, cur.value)
    }
}
catch (Exception e) {
    println "Error reading property file ${propFile.canonicalPath}: ${e.message}"
    System.exit(1)
}
apTool.setOutputProperties()
System.exit(0)
