/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool

def airTool = new AirPluginTool(args[0], args[1])
def props = airTool.getStepProperties()

def baseDir = props['baseDir']
def includes = props['includes']
def excludes = props['excludes'] ?: ""
def followSymlinks = Boolean.valueOf(props['followSymlinks'])
def caseSensitive = Boolean.valueOf(props['caseSensitive'])

println "Working Directory: ${new File('.').canonicalFile}"
println "Base Directory: $baseDir"
println "Include: $includes"
println "Exclude: $excludes"
println "Follow Symlinks: $followSymlinks"
println "Case Sensitive: $caseSensitive"
println "================================="

def errors = false

try {
    if (new File(baseDir).exists()) {
        def ant = new AntBuilder()
        ant.delete(verbose: 'true', includeemptydirs: 'true') {
            fileset(dir:baseDir, casesensitive: caseSensitive, followsymlinks: followSymlinks, defaultexcludes: 'false') {
                includes.split('[\r\n]').each {
                    if (it && it.trim().length() > 0) {
                        include(name: it.trim())
                    }
                }
                excludes.split('[\r\n]').each {
                    if (it && it.trim().length() > 0) {
                        exclude(name: it.trim())
                    }
                }
            }

        }
    }
    else {
        println "$baseDir does not exist, nothing to do!"
    }
}
catch (Exception e) {
    println "Error deleting directories: ${e.message}"
    errors = true
}

if (errors) System.exit 1

System.exit(0)
