/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.update_xml.UpdateXmlFilesStep;
import com.urbancode.air.plugin.update_xml.UpdateXmlFilesStep.FailMode;

File workDir = new File('.').canonicalFile;
def airTool = new AirPluginTool(args[0], args[1]);
def props = airTool.getStepProperties();

String srcDirOffset = props['srcDirOffset'];
String destDirOffset = props['destDirOffset'];
FailMode failMode = FailMode.valueOf(props['failMode']);
String includes = props['includes']?.replaceAll(',', '\n');
String excludes = props['excludes']?.replaceAll(',', '\n');
String replaceText = props['replaceText'];
String setAttr = props['setAttr'];
String removeList = props['remove'];
String insertList = props['insert'];
boolean failWithoutMatch = Boolean.valueOf(props['failWithoutMatch']);
boolean ignoreDTD = Boolean.valueOf(props['ignoreDTD']);
boolean prettyPrint = Boolean.valueOf(props['prettyPrint']);

if (!srcDirOffset) {
    srcDirOffset = '.';
}

if (!destDirOffset) {
    destDirOffset = '.';
}

println "Working Directory: ${workDir}";
println "Source Directory Offset: ${srcDirOffset}";
println "Destination Directory Offset: ${destDirOffset}";
println "File Includes: ${includes}";
println "File Excludes: ${excludes}";
println "-----------------------------";

// get non-empty lines as a list
def asList = { String str -> str.readLines().findAll{it.trim()} };

def step = new UpdateXmlFilesStep();
step.setSrcDir(new File(workDir, srcDirOffset));
step.setIncludes(asList(includes));
step.setExcludes(asList(excludes));
step.setDestDir(new File(workDir, destDirOffset));

step.setFailMode(failMode);
step.setFailWithoutMatch(failWithoutMatch);
step.setIgnoreDTD(ignoreDTD);
step.setPrettyPrint(prettyPrint);

step.setReplaceTextList(asList(replaceText));
step.setInsertList(asList(insertList));
step.setSetAttrList(asList(setAttr));
step.setRemoveList(asList(removeList));

step.execute();
