/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.ini4j.BasicOptionMap;
import org.ini4j.BasicProfile;
import org.ini4j.Config;
import org.ini4j.Configurable;
import org.ini4j.Profile;
import org.ini4j.ResolveLimits;

class BasicProfileSection
extends BasicOptionMap
implements Profile.Section,
Configurable {
    private static final long serialVersionUID = 985800697957194374L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final char REGEXP_ESCAPE_CHAR = '\\';
    private final Pattern _childPattern;
    private final String _name;
    private final BasicProfile _profile;
    private Config _config;

    protected BasicProfileSection(BasicProfile profile, String name) {
        this(profile, name, Config.getGlobal());
    }

    protected BasicProfileSection(BasicProfile profile, String name, Config config) {
        this._profile = profile;
        this._name = name;
        this._childPattern = this.newChildPattern(name);
        if (config == null) {
            config = Config.getGlobal();
        }
        this._config = config;
    }

    @Override
    public Profile.Section getChild(String key) {
        return (Profile.Section)this._profile.get(this.childName(key));
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Profile.Section getParent() {
        Profile.Section ret = null;
        int idx = this._name.lastIndexOf(this._profile.getPathSeparator());
        if (idx >= 0) {
            String name = this._name.substring(0, idx);
            ret = (Profile.Section)this._profile.get(name);
        }
        return ret;
    }

    @Override
    public String getSimpleName() {
        int idx = this._name.lastIndexOf(this._profile.getPathSeparator());
        return idx < 0 ? this._name : this._name.substring(idx + 1);
    }

    @Override
    public Profile.Section addChild(String key) {
        String name = this.childName(key);
        return this._profile.add(name);
    }

    @Override
    public String[] childrenNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String key : this._profile.keySet()) {
            if (!this._childPattern.matcher(key).matches()) continue;
            names.add(key.substring(this._name.length() + 1));
        }
        return names.toArray(EMPTY_STRING_ARRAY);
    }

    @Override
    public Profile.Section lookup(String ... parts) {
        StringBuilder buff = new StringBuilder();
        for (String part : parts) {
            if (buff.length() != 0) {
                buff.append(this._profile.getPathSeparator());
            }
            buff.append(part);
        }
        return (Profile.Section)this._profile.get(this.childName(buff.toString()));
    }

    @Override
    public void removeChild(String key) {
        String name = this.childName(key);
        this._profile.remove(name);
    }

    @Override
    boolean isPropertyFirstUpper() {
        return this._profile.isPropertyFirstUpper();
    }

    @Override
    void resolve(StringBuilder buffer) {
        this._profile.resolve(buffer, this);
    }

    @Override
    protected void resolve0(StringBuilder buffer, ResolveLimits limits) {
        this._profile.resolve0(buffer, this, limits);
    }

    private String childName(String key) {
        StringBuilder buff = new StringBuilder(this._name);
        buff.append(this._profile.getPathSeparator());
        buff.append(key);
        return buff.toString();
    }

    private Pattern newChildPattern(String name) {
        StringBuilder buff = new StringBuilder();
        buff.append('^');
        buff.append(Pattern.quote(name));
        buff.append('\\');
        buff.append(this._profile.getPathSeparator());
        buff.append("[^");
        buff.append('\\');
        buff.append(this._profile.getPathSeparator());
        buff.append("]+$");
        return Pattern.compile(buff.toString());
    }

    @Override
    public Config getConfig() {
        return this._config;
    }

    @Override
    public void setConfig(Config value) {
        this._config = value;
    }
}

