/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.util.regex.Matcher;

final class ResolveLimits {
    static final int maxRecursionDepth = Integer.getInteger("org.ini4j.ResolveLimits.maxRecursionDepth", 10);
    static final int maxExpansionLength = Integer.getInteger("org.ini4j.ResolveLimits.maxExpansionLength", 1000000);
    static final int maxNestedResolveCount = Integer.getInteger("org.ini4j.ResolveLimits.maxNestedResolveCount", 10000);
    private int depth;
    private int count;

    ResolveLimits() {
    }

    void begin() {
        this.checkRecursionDepth();
        this.checkNestedResolveCount();
        ++this.depth;
        ++this.count;
    }

    void end() {
        --this.depth;
    }

    void checkExpansionLength(StringBuilder buffer, Matcher m, String value) {
        long size = buffer.length() - (m.end() - m.start()) + value.length();
        if (size > (long)maxExpansionLength) {
            throw new IllegalArgumentException("expansion too large: " + size);
        }
    }

    private void checkRecursionDepth() {
        if (this.depth >= maxRecursionDepth) {
            throw new IllegalArgumentException("recursion too deep: " + this.depth);
        }
    }

    private void checkNestedResolveCount() {
        if (this.count >= maxNestedResolveCount) {
            throw new IllegalArgumentException("too nested many resolutions: " + this.count);
        }
    }
}

