/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata;

import com.urbancode.air.securedata.BadBase64DataException;
import com.urbancode.commons.util.IO;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;

public class Base64Codec {
    public byte[] encode(byte[] bytes) {
        return Base64.encodeBase64((byte[])bytes);
    }

    public byte[] decode(byte[] bytes) {
        if (!this.isBase64(bytes)) {
            throw new BadBase64DataException();
        }
        return Base64.decodeBase64((byte[])bytes);
    }

    public String encodeToString(byte[] bytes) {
        try {
            return this.newDecoder().decode(ByteBuffer.wrap(this.encode(bytes))).toString();
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public byte[] decodeFromString(String string) {
        try {
            ByteBuffer bytes = this.newEncoder().encode(CharBuffer.wrap(string.toCharArray()));
            return this.decode(bytes.array());
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private boolean isBase64(byte[] bytes) {
        if (bytes.length > 0 && (bytes.length & 3) != 0) {
            return false;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (Base64.isBase64((byte)bytes[i])) continue;
            return false;
        }
        byte[] roundTripped = Base64.encodeBase64((byte[])Base64.decodeBase64((byte[])bytes));
        return Arrays.equals(roundTripped, bytes);
    }

    private CharsetEncoder newEncoder() {
        return IO.ascii().newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    private CharsetDecoder newDecoder() {
        return IO.ascii().newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }
}

