/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.fileutils;

import com.urbancode.airplugins.AirPluginTool;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.NoBannerLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Echo;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.util.CompositeMapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;

public class CopyDirStep {
    private static final Pattern UNICODE_LINE_BREAKS = Pattern.compile("\\R");
    private static final File WORK_DIR = Paths.get(".", new String[0]).toAbsolutePath().normalize().toFile();
    private final String[] args;

    public static void main(String[] args) {
        try {
            new CopyDirStep(args).run();
        }
        catch (Exception e) {
            System.out.printf("Error copying directory: %s%n", e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    CopyDirStep(String[] args) {
        this.args = args;
        args.getClass();
    }

    void run() throws Exception {
        AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1]);
        Properties props = apTool.getStepProperties();
        File sourceDir = CopyDirStep.parseSourceDir(props.getProperty("sourceDir"));
        List<File> destDirList = CopyDirStep.parseToDirs(props.getProperty("destDirList"));
        List<String> includes = CopyDirStep.parsePatterns(props.getProperty("includes"));
        List<String> excludes = CopyDirStep.parsePatterns(props.getProperty("excludes"));
        boolean force = Boolean.parseBoolean(props.getProperty("force"));
        boolean flatten = Boolean.parseBoolean(props.getProperty("flatten"));
        boolean preserveLastModified = Boolean.parseBoolean(props.getProperty("preserveLastModified"));
        List<MapperRule> mapperRules = CopyDirStep.parseMapperRules(props.getProperty("mapperRules"));
        boolean failOnError = Boolean.parseBoolean(props.getProperty("failOnError"));
        Project project = new Project();
        NoBannerLogger logger = new NoBannerLogger();
        logger.setMessageOutputLevel(2);
        logger.setOutputPrintStream(System.out);
        logger.setErrorPrintStream(System.err);
        project.addBuildListener((BuildListener)logger);
        project.init();
        project.setBaseDir(WORK_DIR);
        for (File destDir : destDirList) {
            Echo echo = new Echo();
            echo.setMessage("Preparing Copy from " + sourceDir + " to " + destDir);
            echo.setTaskName("echo");
            echo.setProject(project);
            echo.execute();
            Copy copy = new Copy();
            copy.setVerbose(true);
            copy.setTodir(destDir);
            copy.setOverwrite(true);
            copy.setForce(force);
            copy.setFlatten(flatten);
            copy.setPreserveLastModified(preserveLastModified);
            copy.setFailOnError(failOnError);
            FileSet files = new FileSet();
            files.setDir(sourceDir);
            includes.stream().forEach(pattern -> files.createInclude().setName(pattern));
            excludes.stream().forEach(pattern -> files.createExclude().setName(pattern));
            copy.add((ResourceCollection)files);
            if (!mapperRules.isEmpty()) {
                CompositeMapper mapper = new CompositeMapper();
                mapperRules.stream().map(MapperRule::toGlob).forEach(arg_0 -> ((CompositeMapper)mapper).add(arg_0));
                GlobPatternMapper universalGlob = new GlobPatternMapper();
                universalGlob.setFrom("*");
                universalGlob.setTo("*");
                mapper.add((FileNameMapper)universalGlob);
                copy.add((FileNameMapper)mapper);
            }
            copy.setTaskName("copy");
            copy.setProject(project);
            copy.execute();
        }
    }

    private static File parseSourceDir(String input) {
        if (input == null || (input = input.trim()).isEmpty()) {
            return WORK_DIR;
        }
        return new File(input);
    }

    private static List<String> parsePatterns(String input) {
        return CopyDirStep.parseMultiLineString(input, Function.identity());
    }

    private static List<File> parseToDirs(String input) {
        return CopyDirStep.parseMultiLineString(input, File::new);
    }

    private static List<MapperRule> parseMapperRules(String input) {
        return CopyDirStep.parseMultiLineString(input, MapperRule::create);
    }

    private static <T> List<T> parseMultiLineString(String input, Function<String, T> ctor) {
        if (input == null || (input = input.trim()).isEmpty()) {
            return Collections.emptyList();
        }
        return UNICODE_LINE_BREAKS.splitAsStream(input).map(String::trim).filter(line -> !line.isEmpty()).map(ctor).collect(Collectors.toList());
    }

    static final class MapperRule {
        final String from;
        final String to;

        static MapperRule create(String rule) {
            String[] parts = rule.split("->", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException("The mapper rule \"" + rule + "\" is not valid.");
            }
            for (String part : parts) {
                int firstStar = part.indexOf(42);
                if (firstStar == -1 || part.indexOf(42, firstStar + 1) == -1) continue;
                throw new IllegalArgumentException("The mapping rule \"" + part + "\" cannot contain more than one *.");
            }
            return new MapperRule(parts[0].trim(), parts[1].trim());
        }

        MapperRule(String from, String to) {
            this.from = from;
            this.from.getClass();
            this.to = to;
            this.to.getClass();
        }

        GlobPatternMapper toGlob() {
            GlobPatternMapper glob = new GlobPatternMapper();
            glob.setFrom(this.from);
            glob.setTo(this.to);
            return glob;
        }
    }
}

