/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.update_xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XmlOperation {
    private String xpath;
    protected XPathExpression xpathExpression;

    public XmlOperation(String xpath, XPathExpression xpathExpression) {
        this.xpath = xpath;
        this.xpath.getClass();
        this.xpathExpression = xpathExpression;
        this.xpathExpression.getClass();
    }

    int apply(Document doc) throws XPathExpressionException {
        int result = 0;
        List<Node> nodes = this.findXPathNodes(doc, this.xpathExpression);
        for (Node node : nodes) {
            if (!this.apply(doc, node)) continue;
            ++result;
        }
        return result;
    }

    abstract boolean apply(Document var1, Node var2);

    protected List<Node> findXPathNodes(Document doc, XPathExpression xpathExpression) throws XPathExpressionException {
        NodeList nodes = (NodeList)xpathExpression.evaluate(doc, XPathConstants.NODESET);
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            result.add(nodes.item(i));
        }
        return result;
    }

    public String getXpath() {
        return this.xpath;
    }

    public String toString() {
        return Objects.toString(this.xpath);
    }
}

