/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.update_xml;

import com.urbancode.air.plugin.update_xml.OutputStreamSupplier;
import com.urbancode.air.plugin.update_xml.XmlInsertChildOperation;
import com.urbancode.air.plugin.update_xml.XmlOperation;
import com.urbancode.air.plugin.update_xml.XmlRemoveOperation;
import com.urbancode.air.plugin.update_xml.XmlReplaceOperation;
import com.urbancode.air.plugin.update_xml.XmlSetAttrOperation;
import com.urbancode.air.plugin.update_xml.output.FormattedDataWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DocumentUpdater {
    private static final Logger log = LogManager.getFormatterLogger(DocumentUpdater.class);
    private DocumentBuilder db;
    private DocumentBuilder fragmentBuilder;
    private XPath xpath;
    private boolean prettyPrint = false;
    private boolean failWithoutMatch = false;
    private List<XmlOperation> xmlOperations = new ArrayList<XmlOperation>();

    public DocumentUpdater(DocumentBuilderFactory dbf) throws ParserConfigurationException, TransformerConfigurationException, TransformerFactoryConfigurationError {
        this.db = dbf.newDocumentBuilder();
        this.fragmentBuilder = dbf.newDocumentBuilder();
        this.fragmentBuilder.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
            }
        });
        XPathFactory factory = XPathFactory.newInstance();
        this.xpath = factory.newXPath();
    }

    public void setFailWithoutMatch(boolean failWithoutMatch) {
        this.failWithoutMatch = failWithoutMatch;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    protected void addOperation(XmlOperation operation) {
        this.xmlOperations.add(operation);
    }

    public void addReplaceWithXml(String xpathStr, String xmlFragment) throws XPathExpressionException, ParserConfigurationException, SAXException {
        XPathExpression xpathExpression = this.xpath.compile(xpathStr);
        Node fragment = this.readFragment(xmlFragment);
        this.addOperation(new XmlReplaceOperation(xpathStr, xpathExpression, fragment));
    }

    public void addReplaceWithText(String xpathStr, String text) throws XPathExpressionException, ParserConfigurationException, SAXException {
        XPathExpression xpathExpression = this.xpath.compile(xpathStr);
        Text fragment = this.createNodeFromPlainText(text);
        this.addOperation(new XmlReplaceOperation(xpathStr, xpathExpression, fragment));
    }

    public void addInsertChild(String xpathStr, String xmlFragment) throws XPathExpressionException, ParserConfigurationException, SAXException {
        XPathExpression xpathExpression = this.xpath.compile(xpathStr);
        Node fragment = this.readFragment(xmlFragment);
        this.addOperation(new XmlInsertChildOperation(xpathStr, xpathExpression, fragment));
    }

    public void addSetAttrText(String xpathStr, String attr, String text) throws XPathExpressionException, ParserConfigurationException, SAXException {
        XPathExpression xpathExpression = this.xpath.compile(xpathStr);
        Text textNode = this.createNodeFromPlainText(text);
        this.addOperation(new XmlSetAttrOperation(xpathStr, xpathExpression, attr, textNode));
    }

    public void addRemoveNode(String xpathStr) throws XPathExpressionException {
        XPathExpression xpathExpression = this.xpath.compile(xpathStr);
        this.addOperation(new XmlRemoveOperation(xpathStr, xpathExpression));
    }

    public void processDocument(InputSource src, OutputStreamSupplier out) throws TransformerException, IOException, SAXException, XPathExpressionException {
        this.db.reset();
        Document doc = this.db.parse(src);
        String encoding = this.getDocumentEncoding(doc);
        Transformer serializer = this.getTransfomer();
        this.applyChanges(doc);
        try (OutputStream os = out.get();
             Writer w = this.getWriter(os, encoding);){
            Result res;
            if (!this.prettyPrint) {
                res = new StreamResult(w);
            } else {
                FormattedDataWriter handler = new FormattedDataWriter();
                handler.setIndentStep(2);
                handler.setOutput(w);
                handler.setTransformer(serializer);
                res = new SAXResult(handler);
            }
            this.fixCommentLineEndings(doc);
            if (encoding != null) {
                serializer.setOutputProperty("encoding", encoding);
            }
            serializer.transform(new DOMSource(doc), res);
        }
    }

    void applyChanges(Document doc) throws XPathExpressionException {
        doc.normalize();
        int failCount = 0;
        for (XmlOperation op : this.xmlOperations) {
            int count = op.apply(doc);
            if (count == 0) {
                ++failCount;
                log.warn("Did not find any matches for %s", (Object)op);
            } else {
                log.debug("%s had %d matches", (Object)op, (Object)count);
            }
            doc.normalize();
        }
        if (failCount > 0 && this.failWithoutMatch) {
            throw new RuntimeException(String.format("%d patterns failed to find matches", failCount));
        }
    }

    public Node readFragment(String xmlContent) throws ParserConfigurationException, SAXException {
        xmlContent.getClass();
        try {
            Node node;
            try {
                StringReader xmlReader = new StringReader(xmlContent);
                InputSource xmlSource = new InputSource(xmlReader);
                node = this.getFragmentBuilder().parse(xmlSource).getDocumentElement();
            }
            catch (SAXParseException e) {
                String xml = "\n<xml>" + xmlContent + "</xml>";
                StringReader xmlReader = new StringReader(xml);
                InputSource xmlSource = new InputSource(xmlReader);
                Document fragDoc = this.getFragmentBuilder().parse(xmlSource);
                NodeList children = fragDoc.getDocumentElement().getChildNodes();
                if (children.getLength() == 1) {
                    node = children.item(0);
                }
                node = fragDoc.createDocumentFragment();
                while (children.getLength() > 0) {
                    node.appendChild(children.item(0));
                }
            }
            return node;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Text createNodeFromPlainText(String textContent) throws ParserConfigurationException, SAXException {
        textContent.getClass();
        Document fragDoc = this.getFragmentBuilder().newDocument();
        Text node = fragDoc.createTextNode(textContent);
        return node;
    }

    private DocumentBuilder getFragmentBuilder() {
        this.fragmentBuilder.reset();
        return this.fragmentBuilder;
    }

    private void fixCommentLineEndings(Node n) {
        String lineSeparator = System.lineSeparator();
        if ("\n".equals(lineSeparator)) {
            return;
        }
        NodeList list = n.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node c = list.item(i);
            if (c.getNodeType() == 8) {
                c.setNodeValue(c.getNodeValue().replace("\n", lineSeparator));
                continue;
            }
            this.fixCommentLineEndings(c);
        }
    }

    private String getDocumentEncoding(Document doc) {
        String encoding = doc.getXmlEncoding();
        if (encoding == null) {
            encoding = doc.getInputEncoding();
            log.info("Using the encoding '%s' from the input source", (Object)encoding);
        } else {
            log.info("Using encoding %s from the XML Document", (Object)encoding);
        }
        return encoding;
    }

    private Writer getWriter(OutputStream out, String enc) throws IOException {
        if (enc != null) {
            return new OutputStreamWriter(out, enc);
        }
        return new OutputStreamWriter(out);
    }

    private Transformer getTransfomer() throws TransformerException {
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "no");
        return serializer;
    }
}

