/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.update_xml;

import com.urbancode.air.plugin.update_xml.DocumentUpdater;
import com.urbancode.commons.fileutils.filelister.FileLister;
import com.urbancode.commons.fileutils.filelister.FileListerBuilder;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UpdateXmlFilesStep {
    private static final Logger log = LogManager.getFormatterLogger(UpdateXmlFilesStep.class);
    private final DocumentUpdaterFactory fact;
    private File srcDir;
    private List<String> includes = new ArrayList<String>();
    private List<String> excludes = new ArrayList<String>();
    private File destDir;
    private FailMode failMode = FailMode.WARN_ONLY;
    private boolean failWithoutMatch;
    private boolean ignoreDTD;
    private boolean prettyPrint;
    private List<String> replaceTextList = new ArrayList<String>();
    private List<String> insertList = new ArrayList<String>();
    private List<String> setAttrList = new ArrayList<String>();
    private List<String> removeList = new ArrayList<String>();

    public UpdateXmlFilesStep() {
        this(new DocumentUpdaterFactory());
    }

    protected UpdateXmlFilesStep(DocumentUpdaterFactory fact) {
        this.fact = fact;
        this.fact.getClass();
    }

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setFailMode(FailMode failMode) {
        this.failMode = failMode;
    }

    public void setFailWithoutMatch(boolean failWithoutMatch) {
        this.failWithoutMatch = failWithoutMatch;
    }

    public void setIgnoreDTD(boolean ignoreDTD) {
        this.ignoreDTD = ignoreDTD;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setReplaceTextList(List<String> replaceTextList) {
        this.replaceTextList = replaceTextList;
    }

    public void setInsertList(List<String> insertList) {
        this.insertList = insertList;
    }

    public void setSetAttrList(List<String> setAttrList) {
        this.setAttrList = setAttrList;
    }

    public void setRemoveList(List<String> removeList) {
        this.removeList = removeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException, ParserConfigurationException, TransformerException, XPathException, SAXException {
        String text;
        String xpath;
        int index;
        DocumentBuilderFactory dbf = this.createDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        DocumentUpdater updateXml = this.fact.create(dbf);
        updateXml.setFailWithoutMatch(this.failWithoutMatch);
        updateXml.setPrettyPrint(this.prettyPrint);
        updateXml.setFailWithoutMatch(this.failWithoutMatch);
        for (String line : this.replaceTextList) {
            index = line.indexOf("->");
            if (index <= 0) {
                throw new IllegalArgumentException("Invalid replace text rule found: " + line);
            }
            xpath = line.substring(0, index).trim();
            text = line.substring(index + 2);
            log.info("Replace %s with %s", (Object)xpath, (Object)text);
            updateXml.addReplaceWithText(xpath, text);
        }
        for (String line : this.insertList) {
            index = line.indexOf("->");
            if (index <= 0) {
                throw new IllegalArgumentException("Invalid insert text rule found: " + line);
            }
            xpath = line.substring(0, index).trim();
            text = line.substring(index + 2);
            log.info("Inserting\n%s\nunder %s", (Object)xpath, (Object)text);
            updateXml.addInsertChild(xpath, text);
        }
        for (String line : this.setAttrList) {
            int sepIndex = line.indexOf("->");
            int attrIndex = line.indexOf("/@");
            if (sepIndex <= 0 || attrIndex <= 0) {
                throw new IllegalArgumentException("Invalid set attribute text rule found: " + line);
            }
            String xpath2 = line.substring(0, attrIndex).trim();
            String attr = line.substring(attrIndex + 2, sepIndex).trim();
            String text2 = line.substring(sepIndex + 2);
            log.info("Setting attribute %s on element %s to %s", (Object)attr, (Object)xpath2, (Object)text2);
            updateXml.addSetAttrText(xpath2, attr, text2);
        }
        for (String line : this.removeList) {
            String xpath3 = line.trim();
            log.info("Removing %s", (Object)xpath3);
            updateXml.addRemoveNode(xpath3);
        }
        FileListerBuilder builder = new FileListerBuilder(this.srcDir);
        builder.include(this.includes.toArray(new String[0]));
        builder.exclude(this.excludes.toArray(new String[0]));
        FileLister lister = builder.build();
        List<TypedFile> matchedFiles = lister.list();
        ArrayList<TypedFile> wellformedFiles = new ArrayList<TypedFile>();
        ArrayList<TypedFile> malformedFiles = new ArrayList<TypedFile>();
        List<TypedFile> modifiedFiles = this.ignoreDtd(matchedFiles);
        try {
            for (TypedFile typedFile : matchedFiles) {
                File f = typedFile.translate(this.srcDir);
                try {
                    db.parse(f);
                    wellformedFiles.add(typedFile);
                }
                catch (Exception e) {
                    malformedFiles.add(typedFile);
                    if (this.failMode == FailMode.FAIL_FAST) {
                        log.error("Fail Fast: xml malformed %s", (Object)typedFile.path());
                        throw new IllegalStateException("Xml malformed.", e);
                    }
                    log.warn(String.format("Malformed file: %s - %s", f, e.getMessage()));
                }
            }
            log.info("Wellformed xmls: %s", wellformedFiles);
            log.info("Malformed xmls: %s", malformedFiles);
            if (wellformedFiles.isEmpty()) {
                log.info("No wellformed files found to update. Exiting");
                return;
            }
            for (TypedFile f : wellformedFiles) {
                File src = f.translate(this.srcDir);
                File dest = f.translate(this.destDir);
                FileInputStream fis = new FileInputStream(src);
                Throwable throwable = null;
                try {
                    InputSource in = new InputSource(fis);
                    Files.createDirectories(dest.toPath().getParent(), new FileAttribute[0]);
                    log.info("Processing file %s", (Object)src);
                    log.info("Writing result to %s", (Object)dest);
                    updateXml.processDocument(in, () -> new FileOutputStream(dest));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fis == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)fis).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)fis).close();
                }
            }
        }
        finally {
            this.unignoreDtd(modifiedFiles);
        }
        if (this.failMode == FailMode.FAIL_ON_ANY_FAILURE && !malformedFiles.isEmpty()) {
            throw new IllegalStateException(String.format("Fail On Any Failure: Got %d failures!", malformedFiles.size()));
        }
    }

    public List<TypedFile> ignoreDtd(List<TypedFile> matchedFiles) throws IOException {
        ArrayList<TypedFile> modifiedFiles = new ArrayList<TypedFile>();
        if (this.ignoreDTD) {
            log.warn("[Warning] Temporarily commenting out all DOCTYPE declarations so they may be ignored.");
            for (TypedFile typedFile : matchedFiles) {
                String newFileText;
                File f = typedFile.translate(this.srcDir);
                String fileText = IO.readTextFile(f);
                if (fileText.equals(newFileText = fileText.replaceAll("(<!DOCTYPE.*>)", "<!--$1-->"))) continue;
                IO.writeTextFile(f, newFileText);
                modifiedFiles.add(typedFile);
            }
        }
        return modifiedFiles;
    }

    public void unignoreDtd(List<TypedFile> modifiedFiles) throws IOException {
        if (!modifiedFiles.isEmpty()) {
            log.info("[Action] Removing temporary doctype comments.");
            for (TypedFile typedFile : modifiedFiles) {
                String newFileText;
                File f = typedFile.translate(this.srcDir);
                String fileText = IO.readTextFile(f);
                if (fileText.equals(newFileText = fileText.replaceAll("<!--(<!DOCTYPE.*>)-->", "\n$1\n"))) continue;
                IO.writeTextFile(f, newFileText);
            }
        }
    }

    public DocumentBuilderFactory createDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setFeature("http://apache.org/xml/features/validation/schema", false);
        dbf.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        return dbf;
    }

    public static class DocumentUpdaterFactory {
        public DocumentUpdater create(DocumentBuilderFactory dbf) throws TransformerConfigurationException, ParserConfigurationException, TransformerFactoryConfigurationError {
            DocumentUpdater updateXml = new DocumentUpdater(dbf);
            return updateXml;
        }
    }

    public static enum FailMode {
        WARN_ONLY,
        FAIL_FAST,
        FAIL_ON_ANY_FAILURE;

    }
}

