/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.update_xml;

import com.urbancode.air.plugin.update_xml.XmlOperation;
import javax.xml.xpath.XPathExpression;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlRemoveOperation
extends XmlOperation {
    private static final Logger log = LogManager.getFormatterLogger(XmlRemoveOperation.class);

    public XmlRemoveOperation(String xpath, XPathExpression xpathExpression) {
        super(xpath, xpathExpression);
    }

    @Override
    boolean apply(Document doc, Node node) {
        if (node instanceof Document) {
            log.warn("The Document node was matched by expression %s. It can not be removed.", (Object)this.getXpath());
            return false;
        }
        if (node instanceof Attr) {
            Attr attr = (Attr)node;
            Element element = attr.getOwnerElement();
            element.removeAttributeNode(attr);
        } else {
            Node parent = node.getParentNode();
            if (parent != null) {
                parent.removeChild(node);
            } else {
                log.warn("A node matched by expression %s had no parent node. It can not be removed.", (Object)this.getXpath());
                return false;
            }
        }
        return true;
    }
}

