/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.update_xml;

import com.urbancode.air.plugin.update_xml.XmlContentOperation;
import javax.xml.xpath.XPathExpression;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlReplaceOperation
extends XmlContentOperation {
    private static final Logger log = LogManager.getFormatterLogger(XmlReplaceOperation.class);

    public XmlReplaceOperation(String xpath, XPathExpression xpathExpression, Node node) {
        super(xpath, xpathExpression, node);
    }

    @Override
    boolean apply(Document doc, Node existingNode) {
        if (existingNode instanceof Document) {
            log.warn("The Document node was matched by expression %s. It can not be replaced.", (Object)this.getXpath());
            return false;
        }
        Node content = this.getContent();
        Element docElement = doc.getDocumentElement();
        if (existingNode.equals(docElement) && !Element.class.isInstance(content)) {
            log.warn("The documentElement was matched by expression %s. It can not be replaced with a text node.", (Object)this.getXpath());
            return false;
        }
        Node newNode = doc.importNode(content, true);
        if (existingNode instanceof Attr) {
            if (!Attr.class.isInstance(newNode)) {
                return false;
            }
            Attr attr = (Attr)existingNode;
            Attr newAttr = (Attr)content;
            Element element = attr.getOwnerElement();
            element.removeAttributeNode(attr);
            element.setAttributeNodeNS(newAttr);
        } else {
            Node parent = existingNode.getParentNode();
            Node lastChild = parent.getLastChild();
            if (existingNode.equals(lastChild)) {
                parent.removeChild(existingNode);
                parent.appendChild(newNode);
            } else {
                parent.insertBefore(newNode, existingNode);
                parent.removeChild(existingNode);
            }
        }
        return true;
    }
}

