/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.GitClient;
import com.urbancode.commons.fileutils.FileUtils;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class ImportVersion {
    private Properties inputProperties;
    private Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        int returnCode = 0;
        File repoDir = null;
        try {
            String gitVersionOrTag;
            Properties props = new Properties();
            props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
            PropertyConfigurator.configure((Properties)props);
            Properties agentProps = new Properties();
            agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
            String charsetName = agentProps.getProperty("system.default.encoding");
            String componentName = this.inputProperties.getProperty("componentName");
            String versionName = this.inputProperties.getProperty("versionName");
            String repoUrl = this.inputProperties.getProperty("repoUrl");
            String branch = this.inputProperties.getProperty("branch");
            Boolean recursive = Boolean.parseBoolean(this.inputProperties.getProperty("recursive"));
            String gitUsername = this.inputProperties.getProperty("username");
            String gitPassword = this.inputProperties.getProperty("password");
            String[] includes = this.splitLines(this.inputProperties.getProperty("includes"));
            if (includes.length == 0) {
                includes = new String[]{"**/*"};
            }
            String[] excludes = this.splitLines(this.inputProperties.getProperty("excludes"));
            String gitPath = this.inputProperties.getProperty("gitPath");
            String revision = this.inputProperties.getProperty("versionOrTag");
            boolean watchTags = Boolean.valueOf(this.inputProperties.getProperty("watchTags"));
            boolean executePermissions = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
            boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
            String extensionString = this.inputProperties.getProperty("extensions");
            String[] extensions = new String[]{};
            if (extensionString != null) {
                extensions = extensionString.split(",");
                for (int i = 0; i < extensions.length; ++i) {
                    extensions[i] = extensions[i].trim();
                }
            }
            Charset charset = null;
            if (charsetName != null) {
                charset = Charset.forName(charsetName);
            }
            String username = "PasswordIsAuthToken";
            String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
            String webUrl = System.getenv("AH_WEB_URL");
            URI url = new URI(webUrl);
            if (gitUsername.length() > 0) {
                String encodedGitUsername = URLEncoder.encode(gitUsername, "UTF-8").replaceAll("@", "%40");
                String[] urlArray = repoUrl.split("://");
                if (urlArray.length != 2) {
                    System.out.println("Malformed URL: " + repoUrl);
                }
                repoUrl = urlArray[0] + "://" + encodedGitUsername + (gitPassword.length() > 0 ? ":" + gitPassword : "") + "@" + urlArray[1];
            }
            VersionClient versionClient = new VersionClient(url, username, password);
            ComponentClient componentClient = new ComponentClient(url, username, password);
            GitClient gitClient = new GitClient(gitPath, repoUrl, branch, recursive);
            repoDir = gitClient.cloneRepo();
            String finalName = gitVersionOrTag = this.getVersionOrTag(gitClient, repoDir, watchTags, revision);
            if (versionName != null && versionName.length() > 0) {
                finalName = versionName;
            }
            if (gitVersionOrTag != null) {
                List versions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false));
                boolean hasVersion = versions.contains(finalName);
                if (!hasVersion) {
                    String versionId = versionClient.createVersion(componentName, finalName, " ").toString();
                    this.outputProperties.setProperty("VersionID", versionId);
                    if (isUseVFS) {
                        gitClient.checkoutRevisionOrTag(gitVersionOrTag, repoDir);
                        System.out.println("Uploading artifact files.");
                        versionClient.addVersionFiles(componentName, versionId, repoDir, "", includes, excludes, executePermissions, true, charset, extensions);
                    } else {
                        System.out.println("Skipping Artifact Upload: Component is configured not to use codestation.");
                    }
                } else {
                    System.out.println(String.format("Component Already Has Version: %s", gitVersionOrTag));
                }
            }
        }
        catch (Exception e) {
            System.err.println(String.format("Error Creating New Version: %s", e.getMessage()));
            e.printStackTrace();
            returnCode = 1;
        }
        finally {
            if (repoDir != null && repoDir.exists()) {
                FileUtils.deleteFile((File)repoDir);
            }
        }
        return returnCode;
    }

    private String[] splitLines(String string) {
        String[] firstArr = string.split("\\n|,");
        ArrayList<String> lines = new ArrayList<String>();
        for (String temp : firstArr) {
            if ((temp = temp.trim()) == null || temp.length() <= 0) continue;
            lines.add(temp);
        }
        return lines.toArray(new String[lines.size()]);
    }

    private String getVersionOrTag(GitClient git, File workDir, Boolean watchTags, String revision) throws IOException {
        String result;
        if (watchTags.booleanValue()) {
            System.out.println("Checking for tag");
            result = revision != null && revision.trim().length() > 0 ? revision : git.getLatestTag(workDir);
        } else if (revision != null && revision.length() > 0) {
            System.out.println("Using specific revision " + revision);
            result = revision;
        } else {
            System.out.println("Checking for version");
            result = git.getLatestVersion(workDir);
        }
        return result;
    }
}

