/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.zipwriter;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.zipwriter.ZipContentItem;
import com.urbancode.commons.util.zipwriter.ZipItemWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class ZipWriter {
    private static final Logger log = Logger.getLogger(ZipWriter.class);
    private final Iterable<? extends ZipContentItem> source;

    public ZipWriter(Iterable<? extends ZipContentItem> source) throws IOException {
        Check.nonNull(source, "source");
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out) throws IOException {
        ZipItemWriter itemWriter = new ZipItemWriter();
        boolean exceptionInProgress = true;
        ZipArchiveOutputStream zip = new ZipArchiveOutputStream(out);
        try {
            for (ZipContentItem zipContentItem : this.source) {
                if (log.isDebugEnabled()) {
                    log.debug("Starting entry " + zipContentItem.getPath());
                }
                itemWriter.writeItem(zip, zipContentItem);
                if (!log.isDebugEnabled()) continue;
                log.debug("Finished entry " + zipContentItem.getPath());
            }
            zip.finish();
            if (log.isDebugEnabled()) {
                log.debug("Finished zip");
            }
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely((Closeable)zip, exceptionInProgress);
        }
    }
}

