/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.processes.Processes;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class GitClient {
    private final String gitPath;
    private final String url;
    private final String branch;

    public GitClient(String gitPath, String url, String branch) throws IOException {
        this.gitPath = gitPath;
        this.url = url;
        this.branch = branch;
    }

    public String getLatestTag(File workDir) throws IOException {
        String result = null;
        List<String> command = Arrays.asList(this.gitPath, "describe", "--tags", "--abbrev=0");
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(workDir);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future errorFuture = processes.getErrorStringFuture(process);
            InputStreamReader reader = new InputStreamReader(process.getInputStream());
            BufferedReader bufReader = new BufferedReader(reader);
            result = "";
            while (result.equals("")) {
                result = bufReader.readLine().trim();
            }
            while (bufReader.readLine() != null) {
            }
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("GIT error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        return result;
    }

    public String getLatestVersion(File workDir) throws IOException {
        String result = null;
        List<String> command = Arrays.asList(this.gitPath, "log", "-n", "1", "--format=%H");
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(workDir);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future errorFuture = processes.getErrorStringFuture(process);
            InputStreamReader reader = new InputStreamReader(process.getInputStream());
            BufferedReader bufReader = new BufferedReader(reader);
            result = "";
            while (result.equals("")) {
                result = bufReader.readLine().trim();
            }
            while (bufReader.readLine() != null) {
            }
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("GIT error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        return result;
    }

    public File cloneRepo() throws IOException {
        File result = this.getTempDir();
        List<String> command = Arrays.asList(this.gitPath, "clone", this.url, result.getAbsolutePath());
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future errorFuture = processes.getErrorStringFuture(process);
            IO.copy((InputStream)process.getInputStream(), (OutputStream)IO.NULL);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("GIT error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        if (this.branch != null && !this.branch.trim().equals("")) {
            this.checkoutRevisionOrTag(this.branch, result);
        }
        return result;
    }

    public void checkoutRevisionOrTag(String version, File workDir) throws IOException {
        List<String> command = Arrays.asList(this.gitPath, "checkout", version);
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(workDir);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future errorFuture = processes.getErrorStringFuture(process);
            IO.copy((InputStream)process.getInputStream(), (OutputStream)IO.NULL);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("GIT error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
    }

    private File getTempDir() throws IOException {
        return new File(System.getenv("AGENT_HOME") + "/var/temp", UUID.randomUUID().toString());
    }
}

