/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin;

import com.urbancode.air.plugin.PluginExecutionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Properties;

public class Main {
    private final String[] args;

    public static void main(String[] args) {
        System.exit(new Main(args).execute());
    }

    private Main(String[] args) {
        this.args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute() {
        int result = 0;
        try {
            if (this.args.length != 3) {
                throw new PluginExecutionException("Unexpected number of plugin arguments. Expected arguments: Command class name, input properties file, output properties file");
            }
            String commandClassName = this.args[0];
            String inputPropertiesPath = this.args[1];
            String outputPropertiesPath = this.args[2];
            File inputPropertiesFile = new File(inputPropertiesPath);
            FileInputStream inputPropertiesStream = null;
            Properties inputProperties = new Properties();
            try {
                try {
                    inputPropertiesStream = new FileInputStream(inputPropertiesFile);
                    inputProperties.load(inputPropertiesStream);
                }
                finally {
                    if (inputPropertiesStream != null) {
                        ((InputStream)inputPropertiesStream).close();
                    }
                }
            }
            catch (FileNotFoundException e) {
                throw new PluginExecutionException("Could not locate input properties file at " + inputPropertiesPath);
            }
            Properties outputProperties = new Properties();
            Class<?> commandClass = null;
            String fullClassName = this.getClass().getPackage().getName() + ".command." + commandClassName;
            try {
                commandClass = Class.forName(fullClassName);
            }
            catch (ClassNotFoundException e) {
                throw new PluginExecutionException("No class found at " + fullClassName);
            }
            Constructor<?> constructor = null;
            try {
                constructor = commandClass.getConstructor(Properties.class, Properties.class);
            }
            catch (NoSuchMethodException e) {
                throw new PluginExecutionException("No constructor found for class " + commandClass + " matching signature: public " + commandClass.getSimpleName() + "(Properties inputProperties, Properties outputProperties)");
            }
            Object commandInstance = constructor.newInstance(inputProperties, outputProperties);
            Method executeMethod = null;
            try {
                executeMethod = commandClass.getMethod("execute", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new PluginExecutionException("No method found in class " + commandClass + " matching signature: public int execute()");
            }
            if (executeMethod.getReturnType() != Integer.TYPE && executeMethod.getReturnType() != Integer.class) {
                throw new PluginExecutionException("execute() method in class " + commandClass + " does " + "not return type int or Integer.");
            }
            result = (Integer)executeMethod.invoke(commandInstance, new Object[0]);
            File outputPropertiesFile = new File(outputPropertiesPath);
            FileOutputStream outputPropertiesStream = new FileOutputStream(outputPropertiesFile);
            outputProperties.store(outputPropertiesStream, "");
        }
        catch (PluginExecutionException e) {
            System.out.println(e.getMessage());
            result = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = 1;
        }
        return result;
    }
}

