/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.iterator.files;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.iterator.AbstractSentinelIterator;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
final class EachFileFilterIterator
extends AbstractSentinelIterator<File> {
    private static Comparator<File> FILE_NAME_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File arg0, File arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    };
    final FileFilter traverser;
    final FileFilter acceptor;
    private final List<File> traversalStack = new ArrayList<File>();
    private Iterator<File> enumeratedItems;

    EachFileFilterIterator(File base, FileFilter traverser, FileFilter acceptor) {
        this.traverser = traverser;
        this.acceptor = acceptor;
        this.traversalStack.add(base);
        this.enumeratedItems = Collections.emptyList().iterator();
    }

    @Override
    protected File nextItem() {
        File result = null;
        boolean done = false;
        while (!done) {
            if (!this.enumeratedItems.hasNext()) {
                if (!this.traversalStack.isEmpty()) {
                    File directory = this.popTraversalStack();
                    this.traversalStack.addAll(this.toList(directory.listFiles(this.traverser)));
                    this.enumeratedItems = this.toList(directory.listFiles(this.acceptor)).iterator();
                } else {
                    this.enumeratedItems = Collections.emptyList().iterator();
                    done = true;
                }
            }
            while (!done && this.enumeratedItems.hasNext()) {
                File file;
                result = file = this.enumeratedItems.next();
                done = true;
            }
        }
        return result;
    }

    private List<File> toList(File[] files) {
        if (files == null) {
            return Collections.emptyList();
        }
        Arrays.sort(files, FILE_NAME_COMPARATOR);
        return Arrays.asList(files);
    }

    private File popTraversalStack() {
        File directory = this.traversalStack.remove(this.traversalStack.size() - 1);
        return directory;
    }
}

