/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.crypto.algs.hash;

import com.urbancode.commons.util.crypto.algs.hash.AbstractHashAlgorithm;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;

public class SHA256Alg
extends AbstractHashAlgorithm {
    private static final int SALT_LENGTH = SALT_256_bit;
    private static final char SALT_SEPARATOR_CHAR = '|';
    private static final String DIGEST_ALG = "SHA-256";

    @Override
    public String getAlgPrefix() {
        return "sha256";
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String encode(String value) throws GeneralSecurityException {
        return this.encode0(value);
    }

    @Override
    public boolean validate(String plainText, String cipherText) throws GeneralSecurityException {
        int bound = cipherText.indexOf(124);
        String salt64 = cipherText.substring(0, bound);
        byte[] salt = this.decodeBase64(salt64);
        String encoded = this.encode0(salt, plainText);
        return this.secureEquals(encoded, cipherText);
    }

    @Override
    public boolean shouldReencode(String cipherText) throws GeneralSecurityException {
        return false;
    }

    protected String encode0(String value) throws GeneralSecurityException {
        String result;
        if (value != null) {
            byte[] salt = this.randomSalt(SALT_LENGTH);
            result = this.encode0(salt, value);
        } else {
            result = null;
        }
        return result;
    }

    protected String encode0(byte[] salt, String value) throws GeneralSecurityException {
        String result;
        if (value != null) {
            byte[] data = this.getUtf8Bytes(value);
            MessageDigest sha = MessageDigest.getInstance(DIGEST_ALG);
            sha.update(salt);
            sha.update(data);
            byte[] digest = sha.digest();
            result = this.encodeBase64String(salt) + '|' + this.encodeBase64String(digest);
        } else {
            result = null;
        }
        return result;
    }
}

