/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.xml;

import com.urbancode.commons.xml.DocumentBuilderFactoryBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMUtils {
    private static final Logger log = Logger.getLogger(DOMUtils.class);
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final ThreadLocal<DocumentBuilder> builder = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                DocumentBuilderFactoryBuilder dbfb = DocumentBuilderFactoryBuilder.newBuilder();
                DocumentBuilderFactory dbf = dbfb.newDocumentBuilderFactory();
                return dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    };

    private static byte[] getDefaultCharsetBytes(String s) {
        try {
            return s.getBytes(DEFAULT_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static List<String> getChildElementValues(Element element) {
        ArrayList<String> result = new ArrayList<String>();
        List<Element> childElements = DOMUtils.getChildElementList(element);
        for (Element child : childElements) {
            result.add(DOMUtils.getChildText(child));
        }
        return result;
    }

    public static List<String> getChildElementValues(Element element, String childname) {
        ArrayList<String> result = new ArrayList<String>();
        List<Element> childElements = DOMUtils.getChildElementList(element, childname);
        for (Element child : childElements) {
            result.add(DOMUtils.getChildText(child));
        }
        return result;
    }

    public static List<Element> getChildElementList(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList childList = element.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            if (childList.item(i).getNodeType() != 1) continue;
            result.add((Element)childList.item(i));
        }
        return result;
    }

    public static List<Element> getChildElementList(Element element, String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList childList = element.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            if (!DOMUtils.getUnPrefixedNodeName(childList.item(i)).equals(name)) continue;
            result.add((Element)childList.item(i));
        }
        return result;
    }

    public static Element[] getChildElementArray(Element element, String name) {
        List<Element> resultList = DOMUtils.getChildElementList(element, name);
        return resultList.toArray(new Element[0]);
    }

    public static String getChildText(Element element) throws DOMException {
        StringBuilder result = new StringBuilder();
        NodeList childNodeList = element.getChildNodes();
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            Node node = childNodeList.item(i);
            short type = node.getNodeType();
            if (type != 3 && type != 4) continue;
            result.append(node.getNodeValue());
        }
        return result.toString();
    }

    public static boolean getChildTextAsBoolean(Element element) throws DOMException {
        return Boolean.parseBoolean(DOMUtils.getChildText(element));
    }

    public static Boolean tryGetChildTextAsBoolean(Element element) throws DOMException {
        Boolean result = null;
        String text = DOMUtils.getChildText(element).trim();
        if (text.length() > 0) {
            result = Boolean.valueOf(text);
        }
        return result;
    }

    public static int getChildTextAsInteger(Element element) throws DOMException {
        return Integer.parseInt(DOMUtils.getChildText(element));
    }

    public static Integer tryGetChildTextAsInteger(Element element) throws DOMException {
        Integer result = null;
        String text = DOMUtils.getChildText(element).trim();
        if (text.length() > 0) {
            try {
                result = Integer.valueOf(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static long getChildTextAsLong(Element element) throws DOMException {
        return Long.parseLong(DOMUtils.getChildText(element));
    }

    public static Long tryGetChildTextAsLong(Element element) throws DOMException {
        Long result = null;
        String text = DOMUtils.getChildText(element);
        if (text != null) {
            result = Long.valueOf(text);
        }
        return result;
    }

    public static Element getFirstChild(Element element, String name) {
        Element result = null;
        List<Element> childList = DOMUtils.getChildElementList(element, name);
        if (childList.size() >= 1) {
            result = childList.get(0);
        }
        return result;
    }

    public static String getFirstChildText(Element element, String name) {
        Element child;
        String text = null;
        List<Element> childList = DOMUtils.getChildElementList(element, name);
        if (childList.size() >= 1 && (child = childList.get(0)) != null) {
            text = DOMUtils.getChildText(child);
        }
        return text;
    }

    public static boolean getFirstChildTextAsBoolean(Element element, String name) {
        return Boolean.parseBoolean(DOMUtils.getFirstChildText(element, name));
    }

    public static Boolean tryGetFirstChildTextAsBoolean(Element element, String name) {
        Boolean result = null;
        String text = DOMUtils.getFirstChildText(element, name);
        if (text != null) {
            result = Boolean.valueOf(text);
        }
        return result;
    }

    public static long getFirstChildTextAsLong(Element element, String name) {
        return Long.parseLong(DOMUtils.getFirstChildText(element, name));
    }

    public static Long tryGetFirstChildTextAsLong(Element element, String name) {
        Long result = null;
        String text = DOMUtils.getFirstChildText(element, name);
        if (text != null && text.trim().length() > 0) {
            try {
                result = Long.valueOf(text.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static int getFirstChildTextAsInteger(Element element, String name) {
        return Integer.parseInt(DOMUtils.getFirstChildText(element, name));
    }

    public static Integer tryGetFirstChildTextAsInteger(Element element, String name) {
        Integer result = null;
        String text = DOMUtils.getFirstChildText(element, name);
        if (text != null && text.trim().length() > 0) {
            result = Integer.valueOf(text.trim());
        }
        return result;
    }

    public static Element getFirstChildElement(Element element) {
        Element result = null;
        NodeList childList = element.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            if (childList.item(i).getNodeType() != 1) continue;
            result = (Element)childList.item(i);
            break;
        }
        return result;
    }

    public static String getAttribute(Element element, String attrib) {
        String value = null;
        Node attribNode = element.getAttributes().getNamedItem(attrib);
        if (attribNode != null) {
            value = attribNode.getNodeValue();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadDocument(InputStream in, CharsetDecoder dec) throws ParserConfigurationException, SAXException, IOException {
        try {
            if (in == null) {
                throw new IllegalArgumentException("The parameter in must be non-null.");
            }
            if (dec == null) {
                throw new IllegalArgumentException("The parameter dec must be non-null.");
            }
            DocumentBuilder builder = DOMUtils.getBuilder();
            Document document = builder.parse(new InputSource(new InputStreamReader(in, dec)));
            return document;
        }
        finally {
            block10: {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        if (!log.isEnabledFor(Level.WARN)) break block10;
                        log.warn(e.toString(), e);
                    }
                }
            }
        }
    }

    public static void hardenFactory(DocumentBuilderFactory factory) {
        DocumentBuilderFactoryBuilder.hardenFactory(factory);
    }

    public static Document loadDocument(InputStream in, Charset cs) throws ParserConfigurationException, IOException, SAXException {
        CharsetDecoder decoder = cs.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        decoder.replaceWith("?");
        return DOMUtils.loadDocument(in, decoder);
    }

    public static Document loadDocument(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        return DOMUtils.loadDocument(in, DEFAULT_CHARSET);
    }

    public static Document loadDocument(URL url) throws ParserConfigurationException, SAXException, IOException {
        InputStream in = url.openStream();
        return DOMUtils.loadDocument(in, DEFAULT_CHARSET);
    }

    public static Document loadDocument(String xml) throws ParserConfigurationException, SAXException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(DOMUtils.getDefaultCharsetBytes(xml));
        return DOMUtils.loadDocument((InputStream)in, DEFAULT_CHARSET);
    }

    public static Document loadDocument(Reader reader) throws SAXException, ParserConfigurationException, IOException {
        StringBuilder s = new StringBuilder();
        char[] cbuf = new char[4096];
        int bytesRead = 0;
        while ((bytesRead = reader.read(cbuf)) != -1) {
            s.append(new String(cbuf, 0, bytesRead));
        }
        return DOMUtils.loadDocument(s.toString());
    }

    public static InputStream documentToStream(Document doc) {
        if (doc == null) {
            throw new NullPointerException("Can not transform a null document to a stream.");
        }
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult stream = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(domSource, stream);
            byte[] bytes = DOMUtils.getDefaultCharsetBytes(writer.toString().replaceAll("\r\n|\r", "\n"));
            return new ByteArrayInputStream(bytes);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Error converting XML document to stream: " + e, e);
        }
    }

    public static String documentToString(Document doc) {
        return DOMUtils.documentToString(doc, false);
    }

    public static String documentToString(Document doc, boolean prettyPrint) {
        if (doc == null) {
            throw new NullPointerException("Can not transform a null document to a string.");
        }
        try {
            DocumentType documentType;
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("encoding", DEFAULT_CHARSET.name());
            transformer.setOutputProperty("standalone", "no");
            if (prettyPrint) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            if ((documentType = doc.getDoctype()) != null) {
                if (documentType.getSystemId() != null) {
                    transformer.setOutputProperty("doctype-system", documentType.getSystemId());
                }
                if (documentType.getPublicId() != null) {
                    transformer.setOutputProperty("doctype-public", documentType.getPublicId());
                }
            }
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException("Error converting XML document to string: " + e, e);
        }
    }

    public static String getUnPrefixedNodeName(Node node) {
        String name = null;
        if (node != null) {
            name = node.getLocalName() == null ? node.getNodeName() : node.getLocalName();
        }
        return name;
    }

    private static DocumentBuilder getBuilder() {
        DocumentBuilder result = builder.get();
        result.reset();
        return result;
    }

    private DOMUtils() {
        throw new UnsupportedOperationException();
    }
}

