/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.airplugins;

import com.urbancode.air.securedata.Base64Codec;
import com.urbancode.air.securedata.SecretContainer;
import com.urbancode.air.securedata.SecretContainerImpl;
import com.urbancode.air.securedata.SecureBlob;
import com.urbancode.commons.util.IO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class AirPluginTool {
    private static final String UCD_ENCRYPT_PROPERTIES_ENV_VAR = "UCD_USE_ENCRYPTED_PROPERTIES";
    private static final String UCD_SECRET_VAR = "ucd.properties.secret";
    private final String inPropsFile;
    private final String outPropsFile;
    private final boolean isWindows;
    private Properties outProps;
    private boolean hasReadStdIn;
    private String secret;

    public AirPluginTool(String inPropsFile, String outPropsFile) {
        this.inPropsFile = inPropsFile;
        this.outPropsFile = outPropsFile;
        this.outProps = new Properties();
        this.isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public Properties getStepProperties() throws IOException, GeneralSecurityException {
        return this.getStepProperties(this.getEncKey());
    }

    public void setOutputProperty(String name, String value) {
        this.outProps.setProperty(name, value);
    }

    public void storeOutputProperties() throws IOException, GeneralSecurityException {
        this.setOutputProperties(this.getEncKey());
    }

    public String getAuthToken() {
        String authToken = this.getenv("AUTH_TOKEN");
        return "{\"token\" : \"" + authToken + "\"}";
    }

    public String getAuthTokenUsername() {
        return "PasswordIsAuthToken";
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    private Properties getStepProperties(String encSecret) throws IOException, GeneralSecurityException {
        byte[] sec = this.decodeSecret(encSecret);
        Properties props = new Properties();
        FileInputStream inStream = new FileInputStream(this.inPropsFile);
        if (sec == null) {
            this.loadProperties(props, inStream);
        } else {
            SecretContainer secret = this.newSecretContainer(sec);
            this.loadEncryptedProperties(secret, props, inStream);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEncryptedProperties(SecretContainer secret, Properties props, InputStream inStream) throws IOException, GeneralSecurityException {
        try {
            SecureBlob blob = this.fromEncryptedBytes(secret, inStream);
            this.loadProperties(props, new ByteArrayInputStream(blob.get()));
        }
        finally {
            this.close(inStream);
        }
    }

    private void loadProperties(Properties props, InputStream inStream) {
        try {
            props.load(inStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.close(inStream);
        }
    }

    private String getEncKey() throws IOException {
        if (!this.hasReadStdIn) {
            boolean useEnc = Boolean.valueOf(this.getenv(UCD_ENCRYPT_PROPERTIES_ENV_VAR));
            Properties props = new Properties();
            if (useEnc) {
                props.load(System.in);
                this.secret = props.getProperty(UCD_SECRET_VAR);
                this.hasReadStdIn = true;
            }
        }
        return this.secret;
    }

    private byte[] decodeSecret(String secret) {
        if (secret != null && !secret.trim().equals("")) {
            return this.getBase64Codec().decodeFromString(secret);
        }
        return null;
    }

    private void setOutputProperties(String encSecret) throws IOException, GeneralSecurityException {
        byte[] sec = this.decodeSecret(encSecret);
        FileOutputStream os = new FileOutputStream(this.outPropsFile);
        if (sec == null) {
            this.writePropertiesFile(this.outProps, os);
        } else {
            SecretContainer secretCon = this.newSecretContainer(sec);
            this.writeEncryptedPropertiesFile(secretCon, this.outProps, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEncryptedPropertiesFile(SecretContainer secret, Properties props, OutputStream os) throws IOException, GeneralSecurityException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writePropertiesFile(props, baos);
        try {
            SecureBlob blob = this.fromUnencryptedBytes(secret, baos.toByteArray());
            this.close(baos);
            os.write(blob.getEncryptedBytes());
        }
        finally {
            this.close(os);
        }
    }

    private void writePropertiesFile(Properties props, OutputStream os) throws IOException {
        try {
            props.store(os, "");
        }
        finally {
            this.close(os);
        }
    }

    private Base64Codec getBase64Codec() {
        return new Base64Codec();
    }

    private SecureBlob fromUnencryptedBytes(SecretContainer secret, byte[] os) throws GeneralSecurityException {
        return SecureBlob.fromUnencryptedBytes((SecretContainer)secret, (byte[])os);
    }

    private SecureBlob fromEncryptedBytes(SecretContainer secret, InputStream is) throws IOException, GeneralSecurityException {
        return SecureBlob.fromEncryptedBytes((SecretContainer)secret, (byte[])IO.read((InputStream)is));
    }

    private SecretContainer newSecretContainer(byte[] secret) {
        return new SecretContainerImpl(secret);
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getenv(String key) {
        String value = System.getenv(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return value.trim();
    }
}

