/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.scenarios;

import com.ghc.ghTester.ant.test.CollectionSizeMatcher;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioDetails;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioDetailsFactory;
import com.ghc.ghTester.ant.vie.stubs.AgentSelection;
import com.ghc.ghTester.ant.vie.stubs.InputTag;
import com.ghc.ghTester.ant.vie.stubs.ResponseTimeConfiguration;
import com.ghc.ghTester.ant.vie.stubs.ResponseTimeDistribution;
import com.ghc.ghTester.ant.vie.stubs.StubConfiguration;
import com.ghc.ghTester.ant.vie.stubs.StubDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ScenarioDetailsFactoryTest {
    @Test
    public void test() throws Exception {
        String scenarioXml = "<scenario id=\"scenarioID\" name=\"scenario name\" owner=\"owner username\" status=\"RUNNING\">\r\n    <stubs>\r\n        <stub id=\"UUID\" name=\"name\" version=\"1.1\" href=\"relativeURL\">\r\n             <configuration>\r\n                <tags>\r\n                     <tag name=\"my tag 1\" value=\"default value\" />\r\n                     <tag name=\"my tag 2\" value=\"\" /> <!-- Default to empty string -->\r\n                    <tag name=\"my tag 3\" /> <!-- Default to null -->\r\n                </tags>\r\n                <behaviours>\r\n                     <behaviour name=\"behaviour instance name\">\r\n                         <parameters>\r\n                             <parameter name=\"parameter name\" value=\"default value\" />\r\n                         </parameters>\r\n                    </behaviour>\r\n               </behaviours>\r\n               <logging level=\"DEBUG\" />\r\n               <response-time distribution=\"UNIFORM\" minimum=\"0\" maximum=\"1000\" />\r\n            </configuration>\r\n            <agents>\r\n                <agent>\r\n                   <attributes>\r\n                        <attribute value=\"attribute name 1\" />\r\n                        <attribute value=\"attribute name 2\" />\r\n                   </attributes>\r\n                </agent>\r\n           </agents>\r\n        </stub>\r\n        <stub id=\"UUID2\" name=\"name2\" version=\"1.1\" href=\"relativeURL2\">\r\n            <agents>\r\n                <agent host=\"host name or IP (as specified by agent)\">\r\n                </agent>\r\n           </agents>\r\n        </stub>\r\n    </stubs>\r\n</scenario>";
        ScenarioDetails scenarioDetails = ScenarioDetailsFactory.INSTANCE.createFromXml("/baseURL/file?query", scenarioXml);
        Assert.assertEquals((String)"The scenario's ID", (Object)"scenarioID", (Object)scenarioDetails.id);
        Assert.assertEquals((String)"Scenario name", (Object)"scenario name", (Object)scenarioDetails.name);
        Assert.assertEquals((String)"Scenario owner", (Object)"owner username", (Object)scenarioDetails.owner);
        Assert.assertEquals((String)"Scenario status", (Object)"RUNNING", (Object)scenarioDetails.status);
        Assert.assertThat((String)"Scenario stubs count", (Object)scenarioDetails.stubConfigurations, (Matcher)new CollectionSizeMatcher(2));
        StubConfiguration firstStubConfiguration = (StubConfiguration)scenarioDetails.stubConfigurations.iterator().next();
        Assert.assertEquals((String)"First stub's reference", (Object)new StubDefinition("/baseURL/relativeURL", "UUID", "1.1", "name"), (Object)firstStubConfiguration.stubDefinition);
        ArrayList<InputTag> expectedTags = new ArrayList<InputTag>();
        expectedTags.add(new InputTag("my tag 1", "default value"));
        expectedTags.add(new InputTag("my tag 2", ""));
        expectedTags.add(new InputTag("my tag 3", null));
        Assert.assertEquals((String)"First stub's tags", expectedTags, (Object)firstStubConfiguration.tags);
        ResponseTimeConfiguration expectedReponseTime = new ResponseTimeConfiguration(ResponseTimeDistribution.UNIFORM, 0L, 1000L);
        Assert.assertEquals((String)"Response time", (Object)expectedReponseTime, (Object)firstStubConfiguration.responseTimeConfiguration);
        HashSet<String> expectedAgentAttributes = new HashSet<String>();
        expectedAgentAttributes.add("attribute name 1");
        expectedAgentAttributes.add("attribute name 2");
        List<AgentSelection> expectedAgents = Collections.singletonList(new AgentSelection(expectedAgentAttributes));
        Assert.assertEquals((String)"Agent attributes", expectedAgents, (Object)firstStubConfiguration.agents);
    }
}

