/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant;

import com.ghc.ghTester.ant.vie.stubs.StubStarter;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class StartStub
extends Task {
    private boolean haltOnFailure = false;
    private String failureProperty = null;
    private String versionProperty = null;
    private String serverURL;
    private String domain;
    private String environment;
    private String component;
    private String operation;
    @Deprecated
    private String stub;
    private String name;
    private String version;
    private String async;
    private String attributes;
    private String username;

    public void execute() throws BuildException {
        this.validateInputs();
        int exitCode = this.startStub();
        if (this.haltOnFailure && exitCode != 0) {
            throw new BuildException("StartStub exited with code " + exitCode);
        }
        if (this.failureProperty != null && exitCode != 0) {
            this.getProject().setNewProperty(this.failureProperty, "true");
        }
        this.log("StartStub exited with code " + exitCode, 2);
    }

    private void validateInputs() throws BuildException {
        if (this.domain == null) {
            throw new BuildException("Domain must be specified");
        }
        if (this.environment == null) {
            throw new BuildException("Environment must be specified");
        }
        if (this.getName() == null) {
            throw new BuildException("Stub name must be specified");
        }
        if (this.serverURL == null) {
            throw new BuildException("Server URL must be specified");
        }
    }

    private int startStub() throws BuildException {
        try {
            StubStarter starter = new StubStarter(this.serverURL, this.domain, this.environment, this.component, this.operation, this.getName(), this.version, this.async != null ? Boolean.parseBoolean(this.async) : false, this.convertAttributes(this.attributes), this.username);
            int code = starter.startStub().code;
            if (this.versionProperty != null && starter.getVersion() != null) {
                this.getProject().setNewProperty(this.versionProperty, starter.getVersion());
            }
            return code;
        }
        catch (Exception e) {
            throw new BuildException("An error occurred while running StartStub", (Throwable)e);
        }
    }

    private List<String> convertAttributes(String attributes) {
        if (attributes == null) {
            return null;
        }
        String[] attrs = attributes.split(",");
        ArrayList<String> result = new ArrayList<String>(attrs.length);
        String[] stringArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            result.add(string.trim());
            ++n2;
        }
        return result;
    }

    public void setHaltOnFailure(boolean haltOnError) {
        this.haltOnFailure = haltOnError;
    }

    public void setFailureProperty(String value) {
        this.failureProperty = value;
    }

    public void setVersionProperty(String value) {
        this.versionProperty = value;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Deprecated
    public void setStub(String stub) {
        this.stub = stub;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name == null ? this.stub : this.name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setAsync(String async) {
        this.async = async;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

