/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.scenarios;

import com.ghc.ghTester.ant.vie.DomUtils;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioDetails;
import com.ghc.ghTester.ant.vie.stubs.AgentSelection;
import com.ghc.ghTester.ant.vie.stubs.BehaviourParameter;
import com.ghc.ghTester.ant.vie.stubs.InputTag;
import com.ghc.ghTester.ant.vie.stubs.ResponseTimeConfiguration;
import com.ghc.ghTester.ant.vie.stubs.ResponseTimeDistribution;
import com.ghc.ghTester.ant.vie.stubs.StubConfiguration;
import com.ghc.ghTester.ant.vie.stubs.StubDefinition;
import com.ghc.ghTester.ant.vie.stubs.StubDefinitionFactory;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ScenarioDetailsFactory {
    public static final ScenarioDetailsFactory INSTANCE = new ScenarioDetailsFactory();

    public ScenarioDetails createFromXml(String baseURL, String xml) throws IOException, URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element root = document.getDocumentElement();
        String status = root.getAttribute("status");
        String id = root.getAttribute("id");
        String name = root.getAttribute("name");
        String owner = root.getAttribute("owner");
        List<StubConfiguration> stubConfigurations = Collections.emptyList();
        for (Element child : new DomUtils.ElementIterable(root)) {
            if (!"stubs".equals(child.getNodeName())) continue;
            stubConfigurations = this.buildStubConfigurationsList(baseURL, child.getChildNodes());
            break;
        }
        ScenarioDetails details = new ScenarioDetails(id, name, owner, status, stubConfigurations);
        return details;
    }

    private List<StubConfiguration> buildStubConfigurationsList(String baseURL, NodeList stubNodes) throws URISyntaxException, TransformerException, ParserConfigurationException {
        ArrayList<StubConfiguration> stubConfigurations = new ArrayList<StubConfiguration>(stubNodes.getLength());
        for (Element stubElement : new DomUtils.ElementIterable(stubNodes)) {
            StubConfiguration stubConfiguration = this.buildStubConfiguration(baseURL, stubElement);
            if (stubConfiguration == null) continue;
            stubConfigurations.add(stubConfiguration);
        }
        return stubConfigurations;
    }

    private StubConfiguration buildStubConfiguration(String baseURL, Element stubElement) throws URISyntaxException, TransformerException, ParserConfigurationException {
        StubDefinition stubDefinition = StubDefinitionFactory.INSTANCE.buildStubDef(baseURL, stubElement);
        List<InputTag> inputTags = Collections.emptyList();
        List<BehaviourParameter> behaviourParameters = Collections.emptyList();
        ResponseTimeConfiguration responseTimeConfiguration = null;
        List<AgentSelection> agents = Collections.emptyList();
        for (Element stubChildElement : new DomUtils.ElementIterable(stubElement)) {
            if ("configuration".equals(stubChildElement.getNodeName())) {
                for (Element configChildElement : new DomUtils.ElementIterable(stubChildElement)) {
                    if ("tags".equals(configChildElement.getNodeName())) {
                        inputTags = this.extractTags(configChildElement);
                        continue;
                    }
                    if ("behaviours".equals(configChildElement.getNodeName()) || !"response-time".equals(configChildElement.getNodeName())) continue;
                    responseTimeConfiguration = this.extractResponseTimeConfig(configChildElement);
                }
                continue;
            }
            if (!"agents".equals(stubChildElement.getNodeName())) continue;
            agents = this.extractAgents(stubChildElement);
        }
        return new StubConfiguration(stubDefinition, inputTags, behaviourParameters, responseTimeConfiguration, agents);
    }

    private List<InputTag> extractTags(Element tagsNode) {
        NodeList tagNodes = tagsNode.getChildNodes();
        ArrayList<InputTag> tags = new ArrayList<InputTag>(tagNodes.getLength());
        for (Element element : new DomUtils.ElementIterable(tagNodes)) {
            if (!"tag".equals(element.getNodeName())) continue;
            String tagName = element.getAttribute("name");
            String tagValue = null;
            if (element.hasAttribute("value")) {
                tagValue = element.getAttribute("value");
            }
            tags.add(new InputTag(tagName, tagValue));
        }
        return tags;
    }

    private ResponseTimeConfiguration extractResponseTimeConfig(Element responseTimeElement) {
        String distributionString = responseTimeElement.getAttribute("distribution");
        String minimumString = responseTimeElement.getAttribute("minimum");
        String maximumString = responseTimeElement.getAttribute("maximum");
        ResponseTimeDistribution distribution = null;
        try {
            distribution = ResponseTimeDistribution.valueOf(distributionString);
        }
        catch (Exception exception) {
            return null;
        }
        Long min = null;
        try {
            min = Long.valueOf(minimumString);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        Long max = null;
        try {
            max = Long.valueOf(maximumString);
        }
        catch (NumberFormatException numberFormatException) {
            max = 0L;
        }
        return new ResponseTimeConfiguration(distribution, min, max);
    }

    private List<AgentSelection> extractAgents(Element agentsElement) {
        LinkedList<AgentSelection> agents = new LinkedList<AgentSelection>();
        for (Element agentElement : new DomUtils.ElementIterable(agentsElement)) {
            if (!"agent".equals(agentElement.getNodeName())) continue;
            Set<String> attributes = this.extractAgentAttributes(agentElement);
            agents.add(new AgentSelection(attributes));
        }
        return agents;
    }

    private Set<String> extractAgentAttributes(Element agentElement) {
        HashSet<String> attributes = new HashSet<String>();
        for (Element attributesElement : new DomUtils.ElementIterable(agentElement)) {
            if (!"attributes".equals(attributesElement.getNodeName())) continue;
            for (Element attributeElement : new DomUtils.ElementIterable(attributesElement)) {
                String attribute;
                if (!"attribute".equals(attributeElement.getNodeName()) || "".equals(attribute = attributeElement.getAttribute("value"))) continue;
                attributes.add(attribute);
            }
        }
        return attributes;
    }
}

