/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.stubs.environment;

import com.ghc.ghTester.ant.vie.VieHttpException;
import com.ghc.ghTester.ant.vie.stubs.ExitCode;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentDefinition;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentLockDefinition;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentLockDefinitionFactory;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentService;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class EnvironmentLocker {
    private static final Logger log = Logger.getLogger(EnvironmentLocker.class.getName());
    private static final PrintStream OUT = System.out;
    private static final ExitCode ALREADY_LOCKED = ExitCode.ENVIRONMENT_LOCKED;
    private static final ExitCode UNABLE_TO_LOCK = ExitCode.ACTION_FAILED;
    private final boolean force;
    private final EnvironmentService service;
    private final String username;
    private final String duration;
    private final String reason;
    private final String environmentName;

    public EnvironmentLocker(String url, String domain, String environmentName, String username, String duration, String reason, boolean force) throws URISyntaxException, NumberFormatException {
        this.username = username;
        this.environmentName = environmentName;
        if (duration != null) {
            Long dur = Long.parseLong(duration);
            long millis = TimeUnit.MINUTES.toMillis(dur);
            this.duration = String.valueOf(millis);
        } else {
            this.duration = null;
        }
        this.reason = reason;
        this.service = new EnvironmentService(url, domain);
        this.force = force;
    }

    public ExitCode lock() throws URISyntaxException, ParserConfigurationException, SAXException, TransformerException, InterruptedException {
        return this.lock(null);
    }

    public ExitCode lock(String waitFor) throws URISyntaxException, ParserConfigurationException, SAXException, TransformerException, InterruptedException {
        long waitUntilTime = System.currentTimeMillis();
        if (waitFor != null) {
            Long dur = Long.parseLong(waitFor);
            if (dur == 0L) {
                waitUntilTime = Long.MAX_VALUE;
            } else if (dur > 0L) {
                waitUntilTime += TimeUnit.SECONDS.toMillis(dur);
            }
        }
        EnvironmentDefinition env = null;
        do {
            try {
                env = this.service.locateEnvironment(this.environmentName);
            }
            catch (IOException e) {
                OUT.println("Could not connect to Rational Test Control Panel.");
                OUT.println(e.getMessage());
                return ExitCode.SERVER_CONNECTION_ERROR;
            }
            catch (VieHttpException e) {
                if (e.getStatus() == 412) {
                    OUT.println("Unable to find the domain on Rational Test Control Panel, check supplied parameters.");
                    OUT.println(e.getMessage());
                    return ExitCode.DOMAIN_OR_ENV_NOT_FOUND;
                }
                OUT.println(e.getMessage());
                return ExitCode.UNRECOGNISED_SERVER_ERROR;
            }
            if (env == null) {
                OUT.println("Unable to find the environment on Rational Test Control Panel, check supplied parameters");
                return ExitCode.DOMAIN_OR_ENV_NOT_FOUND;
            }
            EnvironmentLockDefinition lockDetails = null;
            if (!env.isLocked()) continue;
            try {
                lockDetails = this.service.getLockDetails(env);
            }
            catch (IOException e) {
                OUT.println("Could not connect to Rational Test Control Panel.");
                OUT.println(e.getMessage());
            }
            catch (VieHttpException e) {
                OUT.println(e.getMessage());
                return ExitCode.UNRECOGNISED_SERVER_ERROR;
            }
            if (this.username.equalsIgnoreCase(lockDetails.getUser())) continue;
            if (this.force) {
                try {
                    EnvironmentLockDefinition unlockRequest = EnvironmentLockDefinitionFactory.INSTANCE.createUnlockRequest(lockDetails, this.username);
                    this.service.removeLock(unlockRequest);
                }
                catch (IOException e) {
                    OUT.println("Could not connect to Rational Test Control Panel.");
                    OUT.println(e.getMessage());
                }
                catch (VieHttpException e) {
                    if (e.getStatus() == 403) {
                        OUT.println("Not authorised to remove the lock");
                        return ExitCode.UNAUTHORISED;
                    }
                    if (e.getStatus() == 404) {
                        log.info("Unable to remove lock as it doesn't exist: " + lockDetails.getHRef());
                    }
                    if (e.getStatus() == 412) {
                        OUT.println("Unable to find the environment, check supplied parameters");
                        return ExitCode.DOMAIN_OR_ENV_NOT_FOUND;
                    }
                    OUT.println(e.getMessage());
                    return ExitCode.UNRECOGNISED_SERVER_ERROR;
                }
            } else {
                if (System.currentTimeMillis() > waitUntilTime) {
                    OUT.println("Environment is already locked by '" + lockDetails.getUser() + "'");
                    return ALREADY_LOCKED;
                }
                OUT.println("Environment is curently locked by '" + lockDetails.getUser() + "', waiting...");
                Thread.sleep(5000L);
            }
        } while (env.isLocked());
        EnvironmentLockDefinition newLockDetails = new EnvironmentLockDefinition(this.username, null, this.duration, this.reason, env.getLockReferenceHref());
        try {
            this.service.createLock(newLockDetails);
        }
        catch (IOException e) {
            OUT.println("Could not connect to Rational Test Control Panel.");
            OUT.println(e.getMessage());
        }
        catch (VieHttpException e) {
            if (e.getStatus() == 409) {
                OUT.println("Unable to lock as the Environment is already locked by another user");
                return UNABLE_TO_LOCK;
            }
            if (e.getStatus() == 412) {
                OUT.println("Unable to find the environment, check supplied parameters");
                return ExitCode.DOMAIN_OR_ENV_NOT_FOUND;
            }
            OUT.println(e.getMessage());
            return ExitCode.UNRECOGNISED_SERVER_ERROR;
        }
        return ExitCode.SUCCESS;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }
}

