/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.stubs.environment;

import com.ghc.ghTester.ant.vie.DomUtils;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentReferenceDefinition;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EnvironmentReferenceFactory {
    private static final Logger log = Logger.getLogger(EnvironmentReferenceFactory.class.getName());
    public static final EnvironmentReferenceFactory INSTANCE = new EnvironmentReferenceFactory();

    public List<EnvironmentReferenceDefinition> createListFromXml(String baseURL, String xml) throws IOException, URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        LinkedList<EnvironmentReferenceDefinition> result = new LinkedList<EnvironmentReferenceDefinition>();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element root = document.getDocumentElement();
        NodeList childNodes = root.getChildNodes();
        if (childNodes != null) {
            int k = 0;
            while (k < childNodes.getLength()) {
                EnvironmentReferenceDefinition stub;
                Node node = childNodes.item(k);
                if (node.getNodeName().equalsIgnoreCase("environment") && node instanceof Element && (stub = this.buildEnvDef(baseURL, (Element)node)) != null) {
                    result.add(stub);
                }
                ++k;
            }
        }
        return result;
    }

    private EnvironmentReferenceDefinition buildEnvDef(String baseURL, Element element) throws URISyntaxException, TransformerException, ParserConfigurationException {
        String href = element.getAttribute("href");
        String name = element.getAttribute("name");
        if (href != null && name != null) {
            URI uri = new URI(baseURL);
            href = uri.resolve(href).toString();
            EnvironmentReferenceDefinition stubDef = new EnvironmentReferenceDefinition(href, name);
            return stubDef;
        }
        log.severe("Unable to build StubDefinition from XML, href could not be found: " + DomUtils.toXML(element));
        return null;
    }
}

