import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

final def workDir = new File('.').canonicalFile

def apTool = new AirPluginTool(args[0], args[1])
final def props = apTool.getStepProperties()

def rtcpServerURL = props['serverURL'];
println "rtcpServerURL : " + rtcpServerURL;
def domain = props['domain'];
println "domain: " + domain;
def environmentName = props['environmentName'];
println "environmentName: " + environmentName;
def username = props['username'];
println "username: " + username;
def PLUGIN_HOME = System.getenv("PLUGIN_HOME");

def pluginHomeFile = new File(PLUGIN_HOME);
if (!pluginHomeFile.exists()) {
    throw new RuntimeException("Cannot get PLUGIN_HOME");
}

def libDir = new File(pluginHomeFile, "lib");
if (!libDir.exists()) {
    throw new RuntimeException("Cannot get lib directory!");
}

def ant = new AntBuilder();

try {
    ant.path(id:"gh.classpath") {
      fileset(dir:libDir) {
          include(name:"*.jar")
      }
    }
    
    ant.taskdef(name:"deleteEnvironment", classname:"com.ghc.ghTester.ant.DeleteEnvironment", classpathref:"gh.classpath")

    ant.deleteEnvironment(serverURL:"${rtcpServerURL}",
          domain:"${domain}",
          environment:"${environmentName}",
		  username:"${username}",
          failureProperty: "taskFailed")
  
   	if (ant.project.properties.taskFailed == "true")
	{
	  System.out.println("Delete environment failed!");
	  System.exit(1);
	}
	else
	{
	  println "Transient environment deleted: " + environmentName
	}
           

}
catch (Exception e) {
    System.out.println("Error deleting transient environment!");
    e.printStackTrace();
    System.exit(1);
}
