/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.lang;

import com.ghc.lang.Function;
import com.ghc.lang.Predicate;
import com.ghc.lang.Visitor;
import com.ghc.lang.Visitors;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Predicates {
    public static <T> Predicate<T> isInstanceOf(final Class<? extends T> type) {
        return new Predicate<T>(){

            @Override
            public boolean matches(T t) {
                return type.isInstance(t);
            }
        };
    }

    public static <T> boolean contains(Iterable<? extends T> items, Predicate<? super T> predicate) {
        for (T item : items) {
            if (!predicate.matches(item)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Iterable<S>, S> Predicate<T> contains(final Predicate<? super S> where) {
        return new Predicate<T>(){

            @Override
            public boolean matches(T t) {
                return Predicates.contains(t, where);
            }
        };
    }

    public static Predicate<String> contains(final String part) {
        if (part != null) {
            return new Predicate<String>(){

                @Override
                public boolean matches(String full) {
                    return full != null && full.contains(part);
                }
            };
        }
        return Predicates.is(null);
    }

    public static <T> Predicate<T> contains(final Collection<? extends T> items) {
        return new Predicate<T>(){

            @Override
            public boolean matches(T t) {
                return items.contains(t);
            }
        };
    }

    public static <T> Predicate<T> doesNotContain(Collection<? extends T> items) {
        return Predicates.not(Predicates.contains(items));
    }

    public static <T> int count(Iterable<? extends T> items, Predicate<T> predicate) {
        int i = 0;
        for (T item : items) {
            if (!predicate.matches(item)) continue;
            ++i;
        }
        return i;
    }

    public static <T> Predicate<T> and(Predicate<? super T> a, Predicate<? super T> b) {
        if (a == null || b == null) {
            throw new NullPointerException("Predicates can not be null");
        }
        if (a instanceof Not && b instanceof Not) {
            return Predicates.not(Predicates.or(Predicates.not(a), Predicates.not(b)));
        }
        return new And(a, b);
    }

    public static <T> Predicate<T> or(Predicate<? super T> a, Predicate<? super T> b) {
        if (a == null || b == null) {
            throw new NullPointerException("Predicates can not be null");
        }
        if (a instanceof Not && b instanceof Not) {
            return Predicates.not(Predicates.and(Predicates.not(a), Predicates.not(b)));
        }
        return new Or(a, b);
    }

    public static <T> Predicate<T> all() {
        return new True();
    }

    public static <T> Predicate<T> none() {
        return new False();
    }

    public static <T> Predicate<T> is(T object) {
        return new Is(object);
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        if (predicate == null) {
            return null;
        }
        if (predicate instanceof Not) {
            return ((Not)predicate).not;
        }
        return new Not(predicate);
    }

    public static <A, B> Predicate<B> transform(final Predicate<? super A> predicate, final Function<? super B, ? extends A> function) {
        return new Predicate<B>(){

            @Override
            public boolean matches(B t) {
                return predicate.matches(function.apply(t));
            }
        };
    }

    public static <A> Iterable<A> filter(A[] array, Predicate<? super A> predicate) {
        if (array == null) {
            return Collections.emptySet();
        }
        return Predicates.filter(Arrays.asList(array), predicate);
    }

    public static <T extends Collection<? super A>, A> T filter(Iterable<A> in, Predicate<? super A> include, T out) {
        Predicates.filter(in, include, Visitors.of(out));
        return out;
    }

    public static <A> void filter(Iterable<A> in, Predicate<? super A> include, Visitor<? super A> out) {
        for (A a : Predicates.filter(in, include)) {
            out.visit(a);
        }
    }

    public static <A> Iterable<A> filter(final Iterable<A> iterable, final Predicate<? super A> include) {
        return new Iterable<A>(){

            @Override
            public Iterator<A> iterator() {
                return new Iterator<A>(iterable){
                    Iterator<A> iterator;
                    Object unknown;
                    Object next;
                    {
                        this.iterator = iterable.iterator();
                        this.next = this.unknown = new Object();
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Override
                    public boolean hasNext() {
                        if (this.next == this.unknown) ** GOTO lbl7
                        return true;
lbl-1000:
                        // 1 sources

                        {
                            v = this.iterator.next();
                            if (!include.matches(v)) continue;
                            this.next = v;
                            return true;
lbl7:
                            // 2 sources

                            ** while (this.iterator.hasNext())
                        }
lbl8:
                        // 1 sources

                        return false;
                    }

                    @Override
                    public A next() {
                        if (this.next == this.unknown && !this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Object v = this.next;
                        this.next = this.unknown;
                        return v;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> Predicate<T> once(final Predicate<T> predicate) {
        return new Predicate<T>(){
            Map<T, Boolean> results = new HashMap();

            @Override
            public boolean matches(T t) {
                Boolean result = this.results.get(t);
                if (result == null) {
                    result = predicate.matches(t);
                    this.results.put(t, result);
                }
                return result;
            }
        };
    }

    public static <T> Predicate<T> equalTo(final T value) {
        return new Predicate<T>(){

            @Override
            public boolean matches(T t) {
                return value == t || t != null && t.equals(value);
            }
        };
    }

    public static Predicate<String> equalIgnoreCaseTo(final String value) {
        return new Predicate<String>(){

            @Override
            public boolean matches(String t) {
                return value == t || t != null && t.equalsIgnoreCase(value);
            }
        };
    }

    private static final class And<T>
    implements Predicate<T> {
        private final Predicate<? super T> b;
        private final Predicate<? super T> a;

        private And(Predicate<? super T> a, Predicate<? super T> b) {
            this.b = b;
            this.a = a;
        }

        @Override
        public boolean matches(T t) {
            return this.a.matches(t) && this.b.matches(t);
        }

        public String toString() {
            return "( " + this.a.toString() + " && " + this.b.toString() + " )";
        }
    }

    private static final class False<T>
    implements Predicate<T> {
        private False() {
        }

        @Override
        public boolean matches(T t) {
            return false;
        }

        public String toString() {
            return "false";
        }
    }

    private static final class Is<T>
    implements Predicate<T> {
        private final T object;

        private Is(T object) {
            this.object = object;
        }

        @Override
        public boolean matches(T t) {
            return this.object == t;
        }

        public String toString() {
            return "x == " + String.valueOf(this.object);
        }
    }

    private static final class Not<T>
    implements Predicate<T> {
        private final Predicate<T> not;

        private Not(Predicate<T> predicate) {
            this.not = predicate;
        }

        @Override
        public boolean matches(T t) {
            return !this.not.matches(t);
        }

        public String toString() {
            return "not( " + this.not + " )";
        }
    }

    private static final class Or<T>
    implements Predicate<T> {
        private final Predicate<? super T> a;
        private final Predicate<? super T> b;

        private Or(Predicate<? super T> a, Predicate<? super T> b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean matches(T t) {
            return this.a.matches(t) || this.b.matches(t);
        }

        public String toString() {
            return "( " + this.a.toString() + " || " + this.b.toString() + " )";
        }
    }

    private static final class True<T>
    implements Predicate<T> {
        private True() {
        }

        @Override
        public boolean matches(T t) {
            return true;
        }

        public String toString() {
            return "true";
        }
    }
}

