/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.stubs;

import com.ghc.ghTester.ant.vie.VieHttpException;
import com.ghc.ghTester.ant.vie.stubs.ExitCode;
import com.ghc.ghTester.ant.vie.stubs.ResponseTimeConfiguration;
import com.ghc.ghTester.ant.vie.stubs.StubDefinition;
import com.ghc.ghTester.ant.vie.stubs.StubInstance;
import com.ghc.ghTester.ant.vie.stubs.StubsService;
import com.ghc.ghTester.ant.vie.stubs.StubsServiceImpl;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class StubStarter {
    private static final Logger log = Logger.getLogger(StubStarter.class.getName());
    private static final PrintStream OUT = System.out;
    private static final ExitCode NO_STUBS_FOUND = ExitCode.TARGET_NOT_FOUND;
    private static final ExitCode MULTIPLE_STUBS_FOUND = ExitCode.MULTIPLE_TARGETS_FOUND;
    private static final ExitCode FAILED_TO_START = ExitCode.ACTION_FAILED;
    private static final ExitCode STUB_ERROR = ExitCode.ACTION_ERROR;
    private final StubsService service;
    private final ResponseTimeConfiguration responseTime;
    private final List<String> agentAttributes;
    private final boolean async;
    private final String username;
    private boolean terminated = false;
    private String versionLaunched;

    public StubStarter(String url, String domain, String environment, String component, String operation, String stub, String version, boolean async, List<String> agentAttributes, String username) throws URISyntaxException {
        this(url, domain, environment, component, operation, stub, version, async, null, agentAttributes, username, null);
    }

    public StubStarter(String ghServerURL, String domain, String environmentName, String stubId, String stubVersion, boolean async, ResponseTimeConfiguration responseTime, List<String> agentAttributes, String username) throws URISyntaxException {
        this(ghServerURL, domain, environmentName, null, null, null, stubVersion, async, responseTime, agentAttributes, username, stubId);
    }

    private StubStarter(String url, String domain, String environment, String component, String operation, String stub, String version, boolean async, ResponseTimeConfiguration responseTime, List<String> agentAttributes, String username, String stubId) throws URISyntaxException {
        this.service = new StubsServiceImpl(url, domain, environment, component, operation, null, stubId, stub, version);
        this.responseTime = responseTime;
        this.agentAttributes = agentAttributes;
        this.async = async;
        this.username = username;
    }

    public ExitCode startStub() throws URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        try {
            List<StubDefinition> stubDefs;
            if (this.username != null) {
                OUT.println("Using username: " + this.username);
            }
            try {
                stubDefs = this.service.locateStubs();
            }
            catch (VieHttpException e) {
                if (e.getStatus() == 404) {
                    OUT.println("Unable to obtain a list of stubs from the server, check the server version and URL is correct");
                    return ExitCode.SERVER_CONNECTION_ERROR;
                }
                if (e.getStatus() == 412) {
                    OUT.println("Incorrect domain or environment supplied");
                    return ExitCode.DOMAIN_OR_ENV_NOT_FOUND;
                }
                OUT.println(e.getMessage());
                return ExitCode.UNRECOGNISED_SERVER_ERROR;
            }
            if (stubDefs.isEmpty()) {
                OUT.println("No stubs found matching supplied parameters");
                return NO_STUBS_FOUND;
            }
            Iterator<StubDefinition> it = stubDefs.iterator();
            ArrayList<StubDefinition> stubs = new ArrayList<StubDefinition>();
            stubs.add(it.next());
            String stubID = ((StubDefinition)stubs.get(0)).getId();
            while (it.hasNext()) {
                StubDefinition def = it.next();
                if (!stubID.equals(def.getId())) {
                    OUT.println("Multiple stubs found and only 1 can be started at a time, use a more specific set of parameters");
                    return MULTIPLE_STUBS_FOUND;
                }
                stubs.add(def);
            }
            Collections.sort(stubs, Collections.reverseOrder(new StubVersionComparator()));
            StubDefinition stubDefinition = (StubDefinition)stubs.get(0);
            log.finest("Attemping to start: " + stubDefinition);
            this.versionLaunched = stubDefinition.getVersion();
            if (stubs.size() > 1) {
                OUT.println("Multiple versions found, using v" + this.versionLaunched);
            }
            StubInstance instance = null;
            try {
                instance = this.service.startStub(stubDefinition, this.responseTime, this.agentAttributes, this.username);
            }
            catch (VieHttpException e) {
                if (e.getStatus() == 412) {
                    OUT.println("No agents available to start the stub");
                    return ExitCode.AGENT_NOT_FOUND;
                }
                if (e.getStatus() == 423) {
                    OUT.println(e.getMessage());
                    if (this.username == null) {
                        OUT.println("Specify the \"username\" option to start a stub in a locked environment.");
                    }
                    OUT.flush();
                    return ExitCode.ENVIRONMENT_LOCKED;
                }
                OUT.println(e.getMessage());
                return ExitCode.UNRECOGNISED_SERVER_ERROR;
            }
            if (instance == null) {
                OUT.println("Failed to start stub");
                return FAILED_TO_START;
            }
            if (!this.async) {
                OUT.println("Waiting for stub to start...");
                while (!this.terminated) {
                    StubInstance inst;
                    try {
                        inst = this.service.getInstance(instance);
                    }
                    catch (VieHttpException e) {
                        OUT.println(e.getMessage());
                        return ExitCode.UNRECOGNISED_SERVER_ERROR;
                    }
                    if (inst == null) {
                        OUT.println("Stub deployment cancelled.");
                        return ExitCode.ACTION_ERROR;
                    }
                    OUT.println("Current state: " + inst.getStatus());
                    if (inst.isRunning()) {
                        OUT.println("Stub started.");
                        return ExitCode.SUCCESS;
                    }
                    if (inst.isError()) {
                        OUT.println("Stub failed to start with an error.");
                        return STUB_ERROR;
                    }
                    try {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                OUT.println("Stub will be started in the background.");
            }
            return ExitCode.SUCCESS;
        }
        catch (IOException e) {
            OUT.println("Could not connect to Rational Test Control Panel.");
            OUT.println(e.getMessage());
            return ExitCode.SERVER_CONNECTION_ERROR;
        }
    }

    public void terminate() {
        this.terminated = true;
    }

    public String getVersion() {
        return this.versionLaunched;
    }

    static class StubVersionComparator
    implements Comparator<StubDefinition> {
        StubVersionComparator() {
        }

        @Override
        public int compare(StubDefinition o1, StubDefinition o2) {
            String[] vals1 = o1.getVersion().split("\\.");
            String[] vals2 = o2.getVersion().split("\\.");
            int i = 0;
            while (i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i])) {
                ++i;
            }
            if (i < vals1.length && i < vals2.length) {
                int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
                return diff < 0 ? -1 : (diff == 0 ? 0 : 1);
            }
            return vals1.length < vals2.length ? -1 : (vals1.length == vals2.length ? 0 : 1);
        }
    }
}

