/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.winapi;

import com.urbancode.winapi.Handle;
import com.urbancode.winapi.RefInt;
import com.urbancode.winapi.WinApi;
import com.urbancode.winapi.WindowsException;
import com.urbancode.winapi.WindowsIOException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class HandleOutputStream
extends OutputStream {
    private static final Logger log = Logger.getLogger(HandleOutputStream.class);
    private final Handle handle;
    private final boolean closeHandle;

    public HandleOutputStream(Handle handle, boolean closeHandle) {
        if (handle == null) {
            throw new NullPointerException("handle");
        }
        if (!handle.isOpen()) {
            throw new IllegalArgumentException("handle is not open");
        }
        this.handle = handle;
        this.closeHandle = closeHandle;
    }

    public synchronized void close() throws IOException {
        if (this.closeHandle) {
            try {
                this.handle.close();
            }
            catch (WindowsException e) {
                throw new WindowsIOException(e);
            }
        }
    }

    public void write(int b) throws IOException {
        byte[] buffer = new byte[]{(byte)b};
        this.write0(buffer, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("b");
        }
        this.write0(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("b");
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("off < 0");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len < 0");
        }
        if (len > b.length - off) {
            throw new IndexOutOfBoundsException("len + off > b.length");
        }
        this.write0(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write0(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            try {
                RefInt written = new RefInt();
                Thread thread = Thread.currentThread();
                String oldThreadName = null;
                if (log.isTraceEnabled()) {
                    oldThreadName = thread.getName();
                    thread.setName(oldThreadName + ": writing on handle " + this.handle);
                    log.trace((Object)("Writing on handle " + this.handle));
                }
                try {
                    HandleOutputStream handleOutputStream = this;
                    synchronized (handleOutputStream) {
                        WinApi.WriteFile(this.handle, b, off, len, written, null);
                    }
                }
                finally {
                    if (oldThreadName != null) {
                        thread.setName(oldThreadName);
                    }
                }
                off += written.value;
                len -= written.value;
            }
            catch (WindowsException e) {
                throw new WindowsIOException(e);
            }
        }
    }
}

