/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ini;

import com.ghc.lang.Predicate;
import com.ghc.lang.Predicates;
import com.ghc.utils.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IniFile {
    private static final String VMARGS_HEADING = "-vmargs";
    private static final Pattern vmPropertyPattern = Pattern.compile("-D([^=]+)=(.*)");
    private static final Set<Pattern> knownSwitches;
    private final File file;
    private final List<String> applicationArgs = new ArrayList<String>();
    private final Set<String> switches = new LinkedHashSet<String>();
    private final Map<String, String> properties = new LinkedHashMap<String, String>();

    static {
        HashSet<Pattern> temp = new HashSet<Pattern>();
        temp.add(Pattern.compile("-Xmx[0-9]+."));
        temp.add(Pattern.compile("-XX:MaxPermSize=[0-9]+."));
        knownSwitches = Collections.unmodifiableSet(temp);
    }

    public IniFile(File iniFile) {
        this.file = iniFile;
        try {
            if (iniFile.exists()) {
                this.load();
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, null, e);
        }
    }

    public void addApplicationArgument(String line) {
        this.applicationArgs.add(line);
    }

    public void addJvmArgument(String arg) {
        Matcher m = vmPropertyPattern.matcher(arg);
        if (m.matches()) {
            this.setJvmProperty(m.group(1), m.group(2));
        } else {
            this.addSwitch(arg);
        }
    }

    private void addSwitch(String arg) {
        for (Pattern p : Predicates.filter(knownSwitches, new SwitchMatcherPredicate(arg))) {
            if (this.removeMatchingSwitch(p)) break;
        }
        this.switches.add(arg);
    }

    private boolean removeMatchingSwitch(Pattern p) {
        Iterator<String> switchIterator = this.switches.iterator();
        while (switchIterator.hasNext()) {
            Matcher matcher = p.matcher(switchIterator.next());
            if (!matcher.matches()) continue;
            switchIterator.remove();
            return true;
        }
        return false;
    }

    public void removeJvmArgument(String line) {
        Matcher m = vmPropertyPattern.matcher(line);
        if (m.matches()) {
            this.setJvmProperty(m.group(1), null);
        } else {
            this.switches.remove(line);
        }
    }

    public List<String> getApplicationArgs() {
        return Collections.unmodifiableList(this.applicationArgs);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Set<String> getSwitches() {
        return Collections.unmodifiableSet(this.switches);
    }

    public List<String> getJvmArguments() {
        ArrayList<String> lines = new ArrayList<String>();
        for (String string : this.switches) {
            lines.add(string);
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            lines.add(this.formatProperty((String)entry.getKey(), (String)entry.getValue()));
        }
        return lines;
    }

    public final void load() throws FileNotFoundException, IOException {
        this.applicationArgs.clear();
        this.switches.clear();
        this.properties.clear();
        ArrayList<String> lines = new ArrayList<String>();
        if (this.file.exists()) {
            lines.addAll(StringUtils.getLines(this.file));
        }
        this.split(lines);
    }

    public void save() throws IOException {
        FileWriter fw = new FileWriter(this.file);
        BufferedWriter bw = new BufferedWriter(fw);
        PrintWriter pw = new PrintWriter(bw);
        try {
            this.write(pw);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public void setJvmProperty(String key, String value) {
        if (value != null) {
            this.properties.put(key, value);
        } else {
            this.properties.remove(key);
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stringWriter);
        try {
            this.write(pw);
        }
        finally {
            pw.close();
        }
        return stringWriter.toString();
    }

    public void write(PrintWriter writer) {
        this.writeApplicationArgs(writer);
        this.writeVmArgs(writer);
    }

    public void writeApplicationArgs(PrintWriter writer) {
        for (String line : this.applicationArgs) {
            writer.println(line);
        }
    }

    public void writeVmArgs(PrintWriter writer) {
        List<String> jvmArguments = this.getJvmArguments();
        if (!jvmArguments.isEmpty()) {
            writer.println(VMARGS_HEADING);
        }
        for (String arg : jvmArguments) {
            writer.println(arg);
        }
    }

    private String formatProperty(String key, String value) {
        return String.format("-D%s=%s", key, value);
    }

    private void split(List<String> lines) {
        int index = lines.indexOf(VMARGS_HEADING);
        if (index == -1) {
            this.applicationArgs.addAll(lines);
        } else {
            if (index > 0) {
                this.applicationArgs.addAll(lines.subList(0, index));
            }
            for (String line : lines.subList(index + 1, lines.size())) {
                this.addJvmArgument(line);
            }
        }
    }

    private static final class SwitchMatcherPredicate
    implements Predicate<Pattern> {
        private final String switchString;

        private SwitchMatcherPredicate(String switchString) {
            this.switchString = switchString;
        }

        @Override
        public boolean matches(Pattern t) {
            return t.matcher(this.switchString).matches();
        }
    }
}

