/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.winapi;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public final class PathUtil {
    private static final Set<String> specialFiles;

    public static String createLongPath(String path) {
        String result = path;
        if (path != null && !path.startsWith("\\\\?\\") && !PathUtil.isSpecialFile(path)) {
            result = "\\\\?\\" + new File(path).getAbsolutePath();
        }
        return result;
    }

    public static boolean isNul(String path) {
        return PathUtil.getName(path).equalsIgnoreCase("NUL");
    }

    public static boolean isSpecialFile(String path) {
        return specialFiles.contains(PathUtil.getName(path));
    }

    private static String getName(String path) {
        int i;
        String result = path;
        if (result != null && (i = Math.max(path.lastIndexOf(47), path.lastIndexOf(92))) >= 0) {
            result = result.substring(i + 1);
        }
        return result;
    }

    private PathUtil() {
    }

    static {
        TreeSet<String> files = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        files.addAll(Arrays.asList("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"));
        specialFiles = Collections.unmodifiableSet(files);
    }
}

